# copyright (C) 1997-2002 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: apacheu.tcl,v 1.14 2001/12/29 00:32:39 jfontain Exp $}

package provide apacheutilities [lindex {$Revision: 1.14 $} 1]
package require http 2


namespace eval apache {

    # works for both apache and apachex modules, flag can be ?auto, ?notable, ...
    proc url {optionsName hostName moduleName {flag {}}} {
        upvar $optionsName options
        upvar $hostName host

        if {![catch {set url $options(--remote)}]||![catch {set url $options(-r)}]} {
            if {[string first ? $url]>=0} {                                                         ;# we specify the flag ourselves
                error "usage: moodss ... $moduleName \[-r|--remote\] \[http://\]host\[statusLocator\] ..."
            }
            regsub {/$} $url {} url                                                              ;# eventually remove trailing slash
            if {![regexp {[^/]/[^/]} $url]} {                                                    ;# if status locator is not present
                append url /server-status                                                                             ;# use default
            }
            append url $flag
            regsub {^http://} $url {} url                                               ;# eventually remove useless protocol header
            scan $url {%[^/]} host
        } else {
            set url 127.0.0.1/server-status${flag}                                                ;# default for server on localhost
            set host 127.0.0.1
        }
        return $url
    }

    proc configure {optionsName} {
        upvar $optionsName options

        if {[info exists options(--proxyhost)]} {
            ::http::config -proxyhost $options(--proxyhost)
        }
        if {[info exists options(--proxyport)]} {
            ::http::config -proxyport $options(--proxyport)
        }
    }

}
