/*
** Copyright (c) 1998 by Timothy Gerard Endres
** <mailto:time@ice.com>  <http://www.ice.com>
** 
** This program is free software.
** 
** You may redistribute it and/or modify it under the terms of the GNU
** General Public License as published by the Free Software Foundation.
** Version 2 of the license should be included with this distribution in
** the file LICENSE, as well as License.html. If the license is not
** included	with this distribution, you may find a copy at the FSF web
** site at 'www.gnu.org' or 'www.fsf.org', or you may write to the
** Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139 USA.
**
** THIS SOFTWARE IS PROVIDED AS-IS WITHOUT WARRANTY OF ANY KIND,
** NOT EVEN THE IMPLIED WARRANTY OF MERCHANTABILITY. THE AUTHOR
** OF THIS SOFTWARE, ASSUMES _NO_ RESPONSIBILITY FOR ANY
** CONSEQUENCE RESULTING FROM THE USE, MODIFICATION, OR
** REDISTRIBUTION OF THIS SOFTWARE. 
** 
*/

package com.ice.sqlclient;

import java.sql.*;
import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.table.*;

import com.ice.util.AWTUtilities;
import com.ice.util.UserProperties;


public class
TablesPanel extends JPanel
		implements ActionListener, ChangeListener
	{
	private JButton			refreshButton;

	private JPanel			refreshPanel;
	private JPanel			resultPanel;
	private JSplitPane		splitPane;

	private JTable			resultTable;
	private MySQLAdapter	sqlAdapter;
	private JScrollPane		scroller;

	private boolean			isListFresh;
	private int				autoResizeMode;


	public
	TablesPanel()
		{
		this.isListFresh = false;
		this.setDoubleBuffered( true );
		this.establishContents();
		}

	public void
	stateChanged( ChangeEvent event )
		{
		JTabbedPane pane =
			(JTabbedPane) event.getSource();

		if ( pane.getSelectedComponent() == this )
			{
			if ( ! this.isListFresh )
				{
				this.refreshTableList();
				}
			}
		}

	public void
	refreshTableList()
		{
		SQLClientHandler handler = this.getMyHandler();
		if ( handler == null ) return;

		try {
			this.sqlAdapter = (MySQLAdapter)
				handler.getDatabaseTableInfo();

			this.setTableModel( this.sqlAdapter );

			this.isListFresh = true;
			}
		catch ( SQLException ex )
			{
			String msg =
				"SQLException: retrieving table information:\n"
					+ ex.getMessage();
			ErrMsgAdapter msgTable = new ErrMsgAdapter( msg );
			this.setTableModel( msgTable );
			}
		}

	public void
	refresh()
		{
		SQLClientHandler handler = this.getMyHandler();
		if ( handler != null )
			{
			handler.flushTableCaches();
			this.isListFresh = false;
			this.refreshTableList();
			}
		}

	public void
	actionPerformed( ActionEvent event )
		{
		String command = event.getActionCommand();

		if ( command.equals( "REFRESH" ) )
			{
			this.refresh();
			}
		else
			{
			ErrMsgAdapter msgTable =
				new ErrMsgAdapter
					( "INTERNAL ERROR: unknown command: " + command );
			this.setTableModel( msgTable );
			}
		}

	private void
	setTableModel( TableModel model )
		{
		if ( model instanceof ErrMsgAdapter )
			{
			this.resultTable.setAutoResizeMode
				( JTable.AUTO_RESIZE_ALL_COLUMNS );
			}
		else
			{
			this.resultTable.setAutoResizeMode
				( this.autoResizeMode );
			}

		this.resultTable.setModel( model );
		
		this.resultTable.tableChanged
			( new TableModelEvent
				( model, TableModelEvent.HEADER_ROW ) );
		}

	private SQLClientHandler
	getMyHandler()
		{
		SQLClientHandler handler =
			SQLClientHandler.getCurrentHandler();

		if ( handler == null )
			{
			ErrMsgAdapter msgTable =
				new ErrMsgAdapter
					( "INTERNAL ERROR: current handler is null." );
			this.setTableModel( msgTable );
			}
		else if ( ! handler.isOpen() )
			{
			ErrMsgAdapter msgTable =
				new ErrMsgAdapter
					( "INTERNAL ERROR: connection is not open." );
			this.setTableModel( msgTable );
			handler = null;
			}

		return handler;
		}

	private void 
	establishContents()
		{
		JLabel	lbl;
		int		row = 0;

		this.setLayout( new BorderLayout() );

		JButton button = new JButton( "Refresh" );
		button.addActionListener( this );
		button.setActionCommand( "REFRESH" );

		this.add( button, BorderLayout.NORTH );

		this.sqlAdapter =
			new MySQLAdapter( null );

		this.resultTable =
			new JTable( this.sqlAdapter );

		this.autoResizeMode =
			UserProperties.getClassConstant
				( "tablesAutoResizeMode",
					JTable.AUTO_RESIZE_ALL_COLUMNS );

		this.resultTable.setAutoResizeMode
			( this.autoResizeMode );

        this.scroller =
			JTable.createScrollPaneForTable
				( this.resultTable );
		Dimension sz = new Dimension( 300, 50 );
		this.scroller.setMinimumSize( sz );

		this.scroller.setVerticalScrollBarPolicy
			( ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS );

		this.scroller.setHorizontalScrollBarPolicy
			( ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS );

		this.add( this.scroller, BorderLayout.CENTER );
		}

	}


