/*
 * Decompiled with CFR 0.152.
 */
package com.ice.util;

import java.io.FileWriter;
import java.io.PrintWriter;

public class FileLog {
    private static final String RCS_ID = "$Id: FileLog.java,v 1.2 1998/03/14 19:17:58 time Exp $";
    private static final String RCS_REV = "$Revision: 1.2 $";
    private static final String RCS_NAME = "$Name:  $";
    private static final String DEFAULT_FILENAME = "log.txt";
    private static FileLog defaultLogger = null;
    private String filename;
    private FileWriter file;
    private PrintWriter stream;
    private boolean open = false;
    private boolean echo = false;
    private boolean autoFlush = true;

    public static FileLog getDefaultLogger() {
        return defaultLogger;
    }

    public static FileLog setDefaultLogger(FileLog fileLog) {
        FileLog fileLog2 = defaultLogger;
        defaultLogger = fileLog;
        return fileLog2;
    }

    public static void checkDefaultLogger() {
        if (defaultLogger == null) {
            defaultLogger = new FileLog(DEFAULT_FILENAME);
        }
    }

    public FileLog(String string) {
        this.filename = string;
        this.file = null;
        this.stream = null;
    }

    public void setLogFilename(String string) {
        this.filename = string;
    }

    public void setAutoFlush(boolean bl) {
        this.autoFlush = this.autoFlush;
    }

    public void checkLogOpen() {
        if (!this.open) {
            this.openLogFile();
        }
    }

    public void openLogFile() {
        boolean bl = true;
        try {
            this.file = new FileWriter(this.filename);
        }
        catch (Exception exception) {
            System.err.println("error opening log file '" + this.filename + "' - " + exception.getMessage());
            this.file = null;
            bl = false;
        }
        if (bl) {
            this.stream = new PrintWriter(this.file);
            this.open = true;
        }
        this.echo = false;
    }

    public void closeLog() {
        if (this.open) {
            this.open = false;
            if (this.stream != null) {
                this.stream.flush();
                this.stream.close();
                this.stream = null;
            }
        }
    }

    public void setEcho(boolean bl) {
        this.echo = bl;
    }

    public void traceMsg(Throwable throwable, String string) {
        this.logMsg(string);
        this.logMsg(throwable.getMessage());
        if (!this.open) {
            throwable.printStackTrace(System.err);
        } else {
            throwable.printStackTrace(this.stream);
        }
        if (this.autoFlush && this.open) {
            this.stream.flush();
        }
    }

    public static void defLogMsg(String string) {
        FileLog.checkDefaultLogger();
        if (defaultLogger != null) {
            defaultLogger.logMsg(string);
        }
    }

    public void logMsg(String string) {
        this.checkLogOpen();
        if (this.open) {
            this.stream.println(string);
            if (this.autoFlush && this.open) {
                this.stream.flush();
            }
        }
        if (this.echo) {
            System.out.println(string);
        }
    }

    public static void defLogMsgStdout(String string) {
        FileLog.checkDefaultLogger();
        if (defaultLogger != null) {
            defaultLogger.logMsgStdout(string);
        }
    }

    public void logMsgStdout(String string) {
        this.checkLogOpen();
        if (this.open) {
            this.stream.println(string);
            if (this.autoFlush && this.open) {
                this.stream.flush();
            }
        }
        System.out.println(string);
    }

    public static void defLogMsgStderr(String string) {
        FileLog.checkDefaultLogger();
        if (defaultLogger != null) {
            defaultLogger.logMsgStderr(string);
        }
    }

    public void logMsgStderr(String string) {
        this.checkLogOpen();
        if (this.open) {
            this.stream.println(string);
            if (this.autoFlush && this.open) {
                this.stream.flush();
            }
        }
        System.err.println(string);
    }
}

