/*
 * Decompiled with CFR 0.152.
 */
package com.ice.sqlclient;

import com.ice.sqlclient.ErrMsgAdapter;
import com.ice.sqlclient.MySQLAdapter;
import com.ice.sqlclient.SQLClientHandler;
import com.ice.util.UserProperties;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JSplitPane;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.JTable;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.event.TableModelEvent;
import com.sun.java.swing.table.TableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;

public class TablesPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private JButton refreshButton;
    private JPanel refreshPanel;
    private JPanel resultPanel;
    private JSplitPane splitPane;
    private JTable resultTable;
    private MySQLAdapter sqlAdapter;
    private JScrollPane scroller;
    private boolean isListFresh = false;
    private int autoResizeMode;

    public TablesPanel() {
        this.setDoubleBuffered(true);
        this.establishContents();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
        if (jTabbedPane.getSelectedComponent() == this && !this.isListFresh) {
            this.refreshTableList();
        }
    }

    public void refreshTableList() {
        SQLClientHandler sQLClientHandler = this.getMyHandler();
        if (sQLClientHandler == null) {
            return;
        }
        try {
            this.sqlAdapter = (MySQLAdapter)sQLClientHandler.getDatabaseTableInfo();
            this.setTableModel((TableModel)this.sqlAdapter);
            this.isListFresh = true;
            return;
        }
        catch (SQLException sQLException) {
            String string = "SQLException: retrieving table information:\n" + sQLException.getMessage();
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter(string);
            this.setTableModel((TableModel)errMsgAdapter);
            return;
        }
    }

    public void refresh() {
        SQLClientHandler sQLClientHandler = this.getMyHandler();
        if (sQLClientHandler != null) {
            sQLClientHandler.flushTableCaches();
            this.isListFresh = false;
            this.refreshTableList();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("REFRESH")) {
            this.refresh();
            return;
        }
        ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: unknown command: " + string);
        this.setTableModel((TableModel)errMsgAdapter);
    }

    private void setTableModel(TableModel tableModel) {
        if (tableModel instanceof ErrMsgAdapter) {
            this.resultTable.setAutoResizeMode(2);
        } else {
            this.resultTable.setAutoResizeMode(this.autoResizeMode);
        }
        this.resultTable.setModel(tableModel);
        this.resultTable.tableChanged(new TableModelEvent(tableModel, -1));
    }

    private SQLClientHandler getMyHandler() {
        SQLClientHandler sQLClientHandler = SQLClientHandler.getCurrentHandler();
        if (sQLClientHandler == null) {
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: current handler is null.");
            this.setTableModel((TableModel)errMsgAdapter);
        } else if (!sQLClientHandler.isOpen()) {
            ErrMsgAdapter errMsgAdapter = new ErrMsgAdapter("INTERNAL ERROR: connection is not open.");
            this.setTableModel((TableModel)errMsgAdapter);
            sQLClientHandler = null;
        }
        return sQLClientHandler;
    }

    private void establishContents() {
        ((Container)((Object)this)).setLayout(new BorderLayout());
        JButton jButton = new JButton("Refresh");
        jButton.addActionListener((ActionListener)this);
        jButton.setActionCommand("REFRESH");
        ((Container)((Object)this)).add((Component)jButton, "North");
        this.sqlAdapter = new MySQLAdapter(null);
        this.resultTable = new JTable((TableModel)this.sqlAdapter);
        this.autoResizeMode = UserProperties.getClassConstant("tablesAutoResizeMode", 2);
        this.resultTable.setAutoResizeMode(this.autoResizeMode);
        this.scroller = JTable.createScrollPaneForTable((JTable)this.resultTable);
        Dimension dimension = new Dimension(300, 50);
        this.scroller.setMinimumSize(dimension);
        this.scroller.setVerticalScrollBarPolicy(22);
        this.scroller.setHorizontalScrollBarPolicy(32);
        ((Container)((Object)this)).add((Component)this.scroller, "Center");
    }
}

