/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.formatter.impl;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.jdt.core.JavaCore;

public class FormatterOptions {
    public static final String OPTION_InsertNewlineBeforeOpeningBrace = "org.eclipse.jdt.core.formatter.newline.openingBrace";
    public static final String OPTION_InsertNewlineInControlStatement = "org.eclipse.jdt.core.formatter.newline.controlStatement";
    public static final String OPTION_InsertNewLineBetweenElseAndIf = "org.eclipse.jdt.core.formatter.newline.elseIf";
    public static final String OPTION_InsertNewLineInEmptyBlock = "org.eclipse.jdt.core.formatter.newline.emptyBlock";
    public static final String OPTION_ClearAllBlankLines = "org.eclipse.jdt.core.formatter.newline.clearAll";
    public static final String OPTION_SplitLineExceedingLength = "org.eclipse.jdt.core.formatter.lineSplit";
    public static final String OPTION_CompactAssignment = "org.eclipse.jdt.core.formatter.style.assignment";
    public static final String OPTION_TabulationChar = "org.eclipse.jdt.core.formatter.tabulation.char";
    public static final String OPTION_TabulationSize = "org.eclipse.jdt.core.formatter.tabulation.size";
    public static final String OPTION_InsertSpaceAfterCast = "org.eclipse.jdt.core.formatter.space.castexpression";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public boolean newLineBeforeOpeningBraceMode = false;
    public boolean newlineInControlStatementMode = false;
    public boolean clearAllBlankLinesMode = false;
    public int maxLineLength = 80;
    public boolean compactAssignmentMode = false;
    public int tabSize = 4;
    public boolean indentWithTab = true;
    public boolean compactElseIfMode = true;
    public boolean newLineInEmptyBlockMode = true;
    public boolean spaceInCastExpression = false;
    public char[] lineSeparatorSequence = System.getProperty("line.separator").toCharArray();

    public FormatterOptions() {
    }

    public FormatterOptions(Map settings) {
        Object[] entries;
        String optionValue;
        String optionID;
        Map.Entry entry;
        int max;
        int i;
        Hashtable javaCoreOptions = JavaCore.getOptions();
        if (settings != null) {
            Object[] presetEntries = settings.entrySet().toArray();
            i = 0;
            max = presetEntries.length;
            while (i < max) {
                entry = (Map.Entry)presetEntries[i];
                if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                    optionID = (String)entry.getKey();
                    optionValue = (String)entry.getValue();
                    javaCoreOptions.put(optionID, optionValue);
                }
                ++i;
            }
        }
        if ((entries = javaCoreOptions.entrySet().toArray()) == null) {
            return;
        }
        i = 0;
        max = entries.length;
        while (i < max) {
            entry = (Map.Entry)entries[i];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) {
                optionID = (String)entry.getKey();
                optionValue = (String)entry.getValue();
                if (optionID.equals(OPTION_InsertNewlineBeforeOpeningBrace)) {
                    if (optionValue.equals(INSERT)) {
                        this.newLineBeforeOpeningBraceMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newLineBeforeOpeningBraceMode = false;
                    }
                } else if (optionID.equals(OPTION_InsertNewlineInControlStatement)) {
                    if (optionValue.equals(INSERT)) {
                        this.newlineInControlStatementMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newlineInControlStatementMode = false;
                    }
                } else if (optionID.equals(OPTION_ClearAllBlankLines)) {
                    if (optionValue.equals(CLEAR_ALL)) {
                        this.clearAllBlankLinesMode = true;
                    } else if (optionValue.equals(PRESERVE_ONE)) {
                        this.clearAllBlankLinesMode = false;
                    }
                } else if (optionID.equals(OPTION_InsertNewLineBetweenElseAndIf)) {
                    if (optionValue.equals(INSERT)) {
                        this.compactElseIfMode = false;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.compactElseIfMode = true;
                    }
                } else if (optionID.equals(OPTION_InsertNewLineInEmptyBlock)) {
                    if (optionValue.equals(INSERT)) {
                        this.newLineInEmptyBlockMode = true;
                    } else if (optionValue.equals(DO_NOT_INSERT)) {
                        this.newLineInEmptyBlockMode = false;
                    }
                } else {
                    int val2;
                    if (optionID.equals(OPTION_SplitLineExceedingLength)) {
                        try {
                            val2 = Integer.parseInt(optionValue);
                            if (val2 >= 0) {
                                this.maxLineLength = val2;
                            }
                        }
                        catch (NumberFormatException val2) {
                            // empty catch block
                        }
                    }
                    if (optionID.equals(OPTION_CompactAssignment)) {
                        if (optionValue.equals(COMPACT)) {
                            this.compactAssignmentMode = true;
                        } else if (optionValue.equals(NORMAL)) {
                            this.compactAssignmentMode = false;
                        }
                    } else if (optionID.equals(OPTION_TabulationChar)) {
                        if (optionValue.equals(TAB)) {
                            this.indentWithTab = true;
                        } else if (optionValue.equals(SPACE)) {
                            this.indentWithTab = false;
                        }
                    } else {
                        if (optionID.equals(OPTION_TabulationSize)) {
                            try {
                                val2 = Integer.parseInt(optionValue);
                                if (val2 > 0) {
                                    this.tabSize = val2;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        if (optionID.equals(OPTION_InsertSpaceAfterCast)) {
                            if (optionValue.equals(INSERT)) {
                                this.spaceInCastExpression = true;
                            } else if (optionValue.equals(DO_NOT_INSERT)) {
                                this.spaceInCastExpression = false;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    public boolean isAddingNewLineBeforeOpeningBrace() {
        return this.newLineBeforeOpeningBraceMode;
    }

    public boolean isAddingNewLineInControlStatement() {
        return this.newlineInControlStatementMode;
    }

    public boolean isAddingNewLineInEmptyBlock() {
        return this.newLineInEmptyBlockMode;
    }

    public boolean isAddindSpaceInCastExpression() {
        return this.spaceInCastExpression;
    }

    public boolean isClearingAllBlankLines() {
        return this.clearAllBlankLinesMode;
    }

    public boolean isCompactingAssignment() {
        return this.compactAssignmentMode;
    }

    public boolean isCompactingElseIf() {
        return this.compactElseIfMode;
    }

    public boolean isUsingTabForIndenting() {
        return this.indentWithTab;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparatorSequence = lineSeparator.toCharArray();
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }

    public void setCompactElseIfMode(boolean flag) {
        this.compactElseIfMode = flag;
    }
}

