/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class FindSupport {
    private static String[] WS_JAR_VARIANTS = FindSupport.buildWSVariants();
    private static String[] OS_JAR_VARIANTS = FindSupport.buildOSVariants();
    private static String[] NL_JAR_VARIANTS = FindSupport.buildNLVariants(InternalPlatform.getDefault().getEnvironmentInfoService().getNL());
    private static String[] JAR_VARIANTS = FindSupport.buildVanillaVariants();

    private static String[] buildWSVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("ws/" + InternalPlatform.getDefault().getEnvironmentInfoService().getWS());
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildVanillaVariants() {
        return new String[]{""};
    }

    private static String[] buildOSVariants() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("os/" + InternalPlatform.getDefault().getEnvironmentInfoService().getOS() + "/" + InternalPlatform.getDefault().getEnvironmentInfoService().getOSArch());
        result.add("os/" + InternalPlatform.getDefault().getEnvironmentInfoService().getOS());
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    private static String[] buildNLVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        Path base = new Path("nl");
        IPath path = new Path(nl.replace('_', '/'));
        while (path.segmentCount() > 0) {
            result.add(base.append(path).toString());
            if (path.segmentCount() > 1) {
                result.add(base.append(path.toString().replace('/', '_')).toString());
            }
            path = path.removeLastSegments(1);
        }
        return result.toArray(new String[result.size()]);
    }

    private String getFileFromURL(URL target) {
        String protocol = target.getProtocol();
        if (protocol.equals("file")) {
            return target.getFile();
        }
        if (protocol.equals("jar")) {
            String file = target.getFile();
            file = file.substring(0, file.length() - "!/".length());
            try {
                return this.getFileFromURL(new URL(file));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public static URL find(Bundle bundle, IPath path) {
        return FindSupport.find(bundle, path, null);
    }

    public static URL find(Bundle b, IPath path, Map override) {
        if (path == null) {
            return null;
        }
        URL result = null;
        if (path.isEmpty() || path.isRoot()) {
            result = FindSupport.findInPlugin(b, Path.EMPTY);
            if (result == null) {
                result = FindSupport.findInFragments(b, Path.EMPTY);
            }
            return result;
        }
        String first = path.segment(0);
        if (first.charAt(0) != '$') {
            result = FindSupport.findInPlugin(b, path);
            if (result == null) {
                result = FindSupport.findInFragments(b, path);
            }
            return result;
        }
        IPath rest = path.removeFirstSegments(1);
        if (first.equalsIgnoreCase("$nl$")) {
            return FindSupport.findNL(b, rest, override);
        }
        if (first.equalsIgnoreCase("$os$")) {
            return FindSupport.findOS(b, rest, override);
        }
        if (first.equalsIgnoreCase("$ws$")) {
            return FindSupport.findWS(b, rest, override);
        }
        if (first.equalsIgnoreCase("$files$")) {
            return null;
        }
        return null;
    }

    private static URL findOS(Bundle b, IPath path, Map override) {
        String os = null;
        if (override != null) {
            try {
                os = (String)override.get("$os$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (os == null) {
            os = InternalPlatform.getDefault().getEnvironmentInfoService().getOS();
        }
        if (os.length() == 0) {
            return null;
        }
        String osArch = null;
        if (override != null) {
            try {
                osArch = (String)override.get("$arch$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (osArch == null) {
            osArch = InternalPlatform.getDefault().getEnvironmentInfoService().getOSArch();
        }
        if (osArch.length() == 0) {
            return null;
        }
        URL result = null;
        IPath base = new Path("os").append(os).append(osArch);
        while (base.segmentCount() != 1) {
            IPath filePath = base.append(path);
            result = FindSupport.findInPlugin(b, filePath);
            if (result != null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath);
            if (result != null) {
                return result;
            }
            base = base.removeLastSegments(1);
        }
        result = FindSupport.findInPlugin(b, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b, path);
    }

    private static URL findWS(Bundle b, IPath path, Map override) {
        IPath filePath;
        URL result;
        String ws = null;
        if (override != null) {
            try {
                ws = (String)override.get("$ws$");
            }
            catch (ClassCastException classCastException) {}
        }
        if (ws == null) {
            ws = InternalPlatform.getDefault().getEnvironmentInfoService().getWS();
        }
        if ((result = FindSupport.findInPlugin(b, filePath = new Path("ws").append(ws).append(path))) != null) {
            return result;
        }
        result = FindSupport.findInFragments(b, filePath);
        if (result != null) {
            return result;
        }
        result = FindSupport.findInPlugin(b, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b, path);
    }

    private static URL findNL(Bundle b, IPath path, Map override) {
        String nl = null;
        String[] nlVariants = null;
        if (override != null) {
            try {
                nl = (String)override.get("$nl$");
            }
            catch (ClassCastException classCastException) {}
        }
        String[] stringArray = nlVariants = nl == null ? NL_JAR_VARIANTS : FindSupport.buildNLVariants(nl);
        if (nl != null && nl.length() == 0) {
            return null;
        }
        URL result = null;
        int i = 0;
        while (i < nlVariants.length) {
            IPath filePath = new Path(nlVariants[i]).append(path);
            result = FindSupport.findInPlugin(b, filePath);
            if (result != null) {
                return result;
            }
            result = FindSupport.findInFragments(b, filePath);
            if (result != null) {
                return result;
            }
            ++i;
        }
        result = FindSupport.findInPlugin(b, path);
        if (result != null) {
            return result;
        }
        return FindSupport.findInFragments(b, path);
    }

    private static URL findInPlugin(Bundle b, IPath filePath) {
        try {
            return b.getEntry(filePath.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static URL findInFragments(Bundle b, IPath filePath) {
        Bundle[] fragments = b.getFragments();
        if (fragments == null) {
            return null;
        }
        URL fileURL = null;
        int i = 0;
        while (i < fragments.length && fileURL == null) {
            try {
                fileURL = fragments[i].getEntry(filePath.toString());
            }
            catch (IOException iOException) {}
            ++i;
        }
        return fileURL;
    }

    public static final InputStream openStream(Bundle b, IPath file, boolean localized) throws IOException {
        URL url = b.getEntry(file.toString());
        if (url != null) {
            return url.openStream();
        }
        return null;
    }
}

