/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class NotPointcut
extends Pointcut {
    private Pointcut body;

    public NotPointcut(Pointcut left) {
        this.body = left;
    }

    public NotPointcut(Pointcut pointcut, int startPos) {
        this(pointcut);
        this.setLocation(pointcut.getSourceContext(), startPos, pointcut.getEnd());
    }

    public FuzzyBoolean fastMatch(FastMatchInfo type) {
        return this.body.fastMatch(type).not();
    }

    public FuzzyBoolean match(Shadow shadow) {
        return this.body.match(shadow).not();
    }

    public String toString() {
        return "!" + this.body.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof NotPointcut)) {
            return false;
        }
        NotPointcut o = (NotPointcut)other;
        return o.body.equals(this.body);
    }

    public int hashCode() {
        return 851 + this.body.hashCode();
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.body.resolveBindings(scope, null);
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(7);
        this.body.write(s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        NotPointcut ret = new NotPointcut(Pointcut.read(s, context));
        ret.readLocation(context, s);
        return ret;
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        return Test.makeNot(this.body.findResidue(shadow, state));
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        return new NotPointcut(this.body.concretize(inAspect, bindings));
    }
}

