/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.environment.EnvironmentInfo;

public class RegistryCacheReader {
    Factory cacheFactory;
    protected List objectTable = null;
    private boolean lazilyLoadExtensions;
    private MultiStatus cacheReadProblems = null;
    protected File cacheFile;
    public static final byte REGISTRY_CACHE_VERSION = 3;
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;
    public static final byte INDEX = 2;

    public RegistryCacheReader(File cacheFile, Factory factory, boolean lazilyLoadExtensions) {
        this.cacheFile = cacheFile;
        this.lazilyLoadExtensions = lazilyLoadExtensions;
        this.cacheFactory = factory;
        this.objectTable = new ArrayList();
    }

    public RegistryCacheReader(File cacheFile, Factory factory) {
        this(cacheFile, factory, false);
    }

    private int addToObjectTable(Object object) {
        this.objectTable.add(object);
        return this.objectTable.size() - 1;
    }

    private void debug(String msg) {
        System.out.println("RegistryCacheReader: " + msg);
    }

    private boolean readHeaderInformation(DataInputStream in) {
        try {
            if (in.readInt() != 3) {
                return false;
            }
            in.readLong();
            String osStamp = in.readUTF();
            String windowsStamp = in.readUTF();
            String localeStamp = in.readUTF();
            EnvironmentInfo info = InternalPlatform.getDefault().getEnvironmentInfoService();
            return osStamp.equals(info.getOS()) && windowsStamp.equals(info.getWS()) && localeStamp.equals(info.getNL());
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "HeaderInformation"), ioe));
            return false;
        }
    }

    private ConfigurationElement readConfigurationElement(RegistryModelObject parent, DataInputStream in) {
        try {
            ConfigurationElement result = this.cacheFactory.createConfigurationElement();
            result.setParent(parent);
            result.setName(this.readString(in, true));
            result.setValue(this.readString(in, true));
            int length = in.readInt();
            ConfigurationProperty[] properties = new ConfigurationProperty[length];
            int i = 0;
            while (i < length) {
                properties[i] = this.readConfigurationProperty(in);
                ++i;
            }
            result.setProperties(properties);
            length = in.readInt();
            IConfigurationElement[] elements = new ConfigurationElement[length];
            int i2 = 0;
            while (i2 < length) {
                elements[i2] = this.readConfigurationElement(result, in);
                ++i2;
            }
            result.setChildren(elements);
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "ConfigurationElement"), ioe));
            return null;
        }
    }

    private ConfigurationProperty readConfigurationProperty(DataInputStream in) {
        try {
            ConfigurationProperty result = this.cacheFactory.createConfigurationProperty();
            result.setName(this.readString(in, true));
            result.setValue(this.readString(in, true));
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "ConfigurationProperty"), ioe));
            return null;
        }
    }

    private Extension readExtension(DataInputStream in) {
        try {
            Extension result = (Extension)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createExtension();
            this.addToObjectTable(result);
            result.setSimpleIdentifier(this.readString(in, true));
            result.setParent(this.readBundleModel(in));
            result.setName(this.readString(in, false));
            result.setExtensionPointIdentifier(this.readString(in, true));
            result.setSubElements(this.readSubElements(result, in));
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "Extension"), ioe));
            return null;
        }
    }

    private ExtensionPoint readExtensionPoint(DataInputStream in) {
        try {
            ExtensionPoint result = (ExtensionPoint)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createExtensionPoint();
            this.addToObjectTable(result);
            result.setSimpleIdentifier(this.readString(in, true));
            result.setName(this.readString(in, false));
            result.setSchema(this.readString(in, true));
            result.setParent(this.readBundleModel(in));
            int length = in.readInt();
            IExtension[] extensions = new Extension[length];
            int i = 0;
            while (i < length) {
                extensions[i] = this.readExtension(in);
                ++i;
            }
            result.setExtensions(extensions);
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "ExtensionPoint"), ioe));
            return null;
        }
    }

    private BundleModel readBundleModel(DataInputStream in) {
        try {
            BundleModel result = (BundleModel)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createBundle();
            this.addToObjectTable(result);
            result.setUniqueIdentifier(this.readString(in, true));
            result.setId(in.readLong());
            result.setParent(this.readRegistry(in));
            result.setHostIdentifier(this.readString(in, true));
            int length = in.readInt();
            IExtensionPoint[] extensionPoints = new ExtensionPoint[length];
            int i = 0;
            while (i < length) {
                extensionPoints[i] = this.readExtensionPoint(in);
                ++i;
            }
            result.setExtensionPoints(extensionPoints);
            length = in.readInt();
            IExtension[] extensions = new Extension[length];
            int i2 = 0;
            while (i2 < length) {
                extensions[i2] = this.readExtension(in);
                ++i2;
            }
            result.setExtensions(extensions);
            length = in.readInt();
            BundleModel[] bundles = new BundleModel[length];
            int i3 = 0;
            while (i3 < length) {
                bundles[i3] = this.readBundleModel(in);
                ++i3;
            }
            result.setFragments(bundles);
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "Bundle"), ioe));
            return null;
        }
    }

    private ExtensionRegistry readCache(DataInputStream in) {
        if (this.cacheReadProblems == null) {
            this.cacheReadProblems = new MultiStatus("org.eclipse.core.runtime", 1, Policy.bind("meta.registryCacheReadProblems"), null);
        }
        if (!this.readHeaderInformation(in)) {
            if (InternalPlatform.DEBUG_REGISTRY) {
                this.debug("Cache header information out of date - ignoring cache");
            }
            return null;
        }
        return this.readRegistry(in);
    }

    private ExtensionRegistry readRegistry(DataInputStream in) {
        try {
            ExtensionRegistry result = (ExtensionRegistry)this.readIndex(in);
            if (result != null) {
                return result;
            }
            result = this.cacheFactory.createRegistry();
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            this.addToObjectTable(result);
            int length = in.readInt();
            if (length == 0) {
                return null;
            }
            int i = 0;
            while (i < length) {
                result.basicAdd(this.readBundleModel(in), false);
                ++i;
            }
            if (this.lazilyLoadExtensions) {
                result.setCacheReader(this);
            }
            return result;
        }
        catch (IOException ioe) {
            this.cacheReadProblems.add(new Status(2, "org.eclipse.core.runtime", 1, Policy.bind("meta.regCacheIOException", "ExtensionRegistry"), ioe));
            return null;
        }
    }

    private ConfigurationElement[] readSubElements(Extension parent, DataInputStream in) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        int offset = in.readInt();
        if (this.lazilyLoadExtensions) {
            Extension extension = parent;
            extension.setSubElementsCacheOffset(offset);
            this.checkSubElements(parent, in);
            extension.setFullyLoaded(false);
            return null;
        }
        return this.readBasicSubElements(parent, in);
    }

    private ConfigurationElement[] readBasicSubElements(Extension parent, DataInputStream in) throws IOException {
        in.readInt();
        int length = in.readInt();
        ConfigurationElement[] result = new ConfigurationElement[length];
        int i = 0;
        while (i < length) {
            result[i] = this.readConfigurationElement(parent, in);
            if (result[i] == null) {
                String message = "Unable to read subelement #" + i + " for extension " + parent.getName();
                throw new InvalidRegistryCacheException(message);
            }
            ++i;
        }
        in.readLong();
        return result;
    }

    private void checkSubElements(Extension parent, DataInputStream in) throws IOException {
        CheckedInputStream checkedIn = new CheckedInputStream(in, new CRC32());
        int subElementsDataLength = in.readInt();
        if (checkedIn.skip(subElementsDataLength) != (long)subElementsDataLength) {
            String message = null;
            if (InternalPlatform.DEBUG_REGISTRY) {
                message = "EOF checking sub-elements data for extension " + parent.getName();
            }
            throw new InvalidRegistryCacheException(message);
        }
        long checksum = in.readLong();
        if (checksum != checkedIn.getChecksum().getValue()) {
            String message = null;
            if (InternalPlatform.DEBUG_REGISTRY) {
                message = "Checksum error checking sub-elements data for extension " + parent.getName();
            }
            throw new InvalidRegistryCacheException(message);
        }
    }

    private String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        if (intern) {
            return in.readUTF().intern();
        }
        return in.readUTF();
    }

    private Object readIndex(DataInputStream in) throws IOException {
        byte type = in.readByte();
        return type == 2 ? this.objectTable.get(in.readInt()) : null;
    }

    private DataInputStream openCacheFile() throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(this.cacheFile), 2048));
    }

    public final ConfigurationElement[] loadConfigurationElements(Extension parent, int offset) {
        try {
            ConfigurationElement[] configurationElementArray;
            DataInputStream in = this.openCacheFile();
            try {
                in.skipBytes(offset);
                in.readInt();
                configurationElementArray = this.readBasicSubElements(parent, in);
                Object var4_6 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return configurationElementArray;
        }
        catch (IOException e) {
            if (InternalPlatform.DEBUG_REGISTRY) {
                e.printStackTrace(System.err);
            }
            return null;
        }
    }

    public final ExtensionRegistry loadCache() {
        try {
            ExtensionRegistry extensionRegistry;
            DataInputStream in = this.openCacheFile();
            try {
                extensionRegistry = this.readCache(in);
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_5 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return extensionRegistry;
        }
        catch (Throwable t) {
            if (InternalPlatform.DEBUG_REGISTRY) {
                System.err.println("Error opening cache file: " + t.getMessage());
            }
            return null;
        }
    }

    public class InvalidRegistryCacheException
    extends IOException {
        public InvalidRegistryCacheException() {
        }

        public InvalidRegistryCacheException(String string) {
            super(string);
        }
    }
}

