/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.ConnectionTester;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.c3p0.impl.C3P0PooledConnection;
import com.mchange.v2.c3p0.impl.NewPooledConnection;
import com.mchange.v2.c3p0.impl.WrapperConnectionPoolDataSourceBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class WrapperConnectionPoolDataSource
extends WrapperConnectionPoolDataSourceBase
implements ConnectionPoolDataSource {
    ConnectionTester connectionTester = C3P0Defaults.connectionTester();

    public WrapperConnectionPoolDataSource() {
        VetoableChangeListener setConnectionTesterListener = new VetoableChangeListener(){

            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                Object val = evt.getNewValue();
                try {
                    if ("connectionTesterClassName".equals(evt.getPropertyName())) {
                        WrapperConnectionPoolDataSource.this.recreateConnectionTester((String)val);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new PropertyVetoException("Could not instantiate connection tester class with name '" + val + "'.", evt);
                }
            }
        };
        this.addVetoableChangeListener(setConnectionTesterListener);
    }

    public synchronized PooledConnection getPooledConnection() throws SQLException {
        Connection conn = this.getNestedDataSource().getConnection();
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PooledConnection getPooledConnection(String user, String password) throws SQLException {
        Connection conn = this.getNestedDataSource().getConnection(user, password);
        if (this.isUsesTraditionalReflectiveProxies()) {
            return new C3P0PooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
        }
        return new NewPooledConnection(conn, this.connectionTester, this.isAutoCommitOnClose(), this.isForceIgnoreUnresolvedTransactions());
    }

    public synchronized PrintWriter getLogWriter() throws SQLException {
        return this.getNestedDataSource().getLogWriter();
    }

    public synchronized void setLogWriter(PrintWriter out) throws SQLException {
        this.getNestedDataSource().setLogWriter(out);
    }

    public synchronized void setLoginTimeout(int seconds) throws SQLException {
        this.getNestedDataSource().setLoginTimeout(seconds);
    }

    public synchronized int getLoginTimeout() throws SQLException {
        return this.getNestedDataSource().getLoginTimeout();
    }

    public synchronized String getUser() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getUser();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public synchronized String getPassword() {
        try {
            return C3P0ImplUtils.findAuth(this.getNestedDataSource()).getPassword();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void recreateConnectionTester(String className) throws Exception {
        ConnectionTester ct;
        this.connectionTester = className != null ? (ct = (ConnectionTester)Class.forName(className).newInstance()) : C3P0Defaults.connectionTester();
    }
}

