/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0;

import com.mchange.v2.c3p0.PooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.PoolBackedDataSourceBase;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public final class PoolBackedDataSource
extends PoolBackedDataSourceBase
implements PooledDataSource {
    static final String NO_CPDS_ERR_MSG = "Attempted to use an uninitialized PoolBackedDataSource. Please call setConnectionPoolDataSource( ... ) to initialize.";
    transient C3P0PooledConnectionPoolManager poolManager;
    transient boolean is_closed = false;

    public PoolBackedDataSource() {
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                PoolBackedDataSource.this.resetPoolManager();
            }
        };
        this.addPropertyChangeListener(l);
    }

    public Connection getConnection() throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool().checkoutPooledConnection();
        return pc.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection pc = this.getPoolManager().getPool(username, password).checkoutPooledConnection();
        return pc.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.assertCpds().getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.assertCpds().setLogWriter(out);
    }

    public int getLoginTimeout() throws SQLException {
        return this.assertCpds().getLoginTimeout();
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.assertCpds().setLoginTimeout(seconds);
    }

    public int getNumConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumConnections();
    }

    public int getNumIdleConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumIdleConnections();
    }

    public int getNumBusyConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections() throws SQLException {
        return this.getPoolManager().getPool().getNumUnclosedOrphanedConnections();
    }

    public int getNumConnectionsDefaultUser() throws SQLException {
        return this.getNumConnections();
    }

    public int getNumIdleConnectionsDefaultUser() throws SQLException {
        return this.getNumIdleConnections();
    }

    public int getNumBusyConnectionsDefaultUser() throws SQLException {
        return this.getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnectionsDefaultUser() throws SQLException {
        return this.getNumUnclosedOrphanedConnections();
    }

    public void softResetDefaultUser() throws SQLException {
        this.getPoolManager().getPool().reset();
    }

    public int getNumConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumConnections();
    }

    public int getNumIdleConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumIdleConnections();
    }

    public int getNumBusyConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumBusyConnections();
    }

    public int getNumUnclosedOrphanedConnections(String username, String password) throws SQLException {
        return this.getPoolManager().getPool(username, password).getNumUnclosedOrphanedConnections();
    }

    public void softReset(String username, String password) throws SQLException {
        this.getPoolManager().getPool(username, password).reset();
    }

    public int getNumBusyConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumBusyConnectionsAllAuths();
    }

    public int getNumIdleConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumIdleConnectionsAllAuths();
    }

    public int getNumConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumConnectionsAllAuths();
    }

    public int getNumUnclosedOrphanedConnectionsAllUsers() throws SQLException {
        return this.getPoolManager().getNumUnclosedOrphanedConnectionsAllAuths();
    }

    public void softResetAllUsers() throws SQLException {
        this.getPoolManager().softResetAllAuths();
    }

    public int getNumUserPools() throws SQLException {
        return this.getPoolManager().getNumManagedAuths();
    }

    public synchronized void hardReset() {
        C3P0PooledConnectionPoolManager forceDestroyMe = this.poolManager;
        this.resetPoolManager();
        forceDestroyMe.forceDestroy();
    }

    public void close() {
        this.close(false);
    }

    public synchronized void close(boolean force_destroy) {
        C3P0PooledConnectionPoolManager forceDestroyMe = force_destroy ? this.poolManager : null;
        this.resetPoolManager();
        if (force_destroy) {
            forceDestroyMe.forceDestroy();
        }
        this.is_closed = true;
    }

    synchronized void resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.unregisterActiveClient(this);
            this.poolManager = null;
        }
    }

    private synchronized ConnectionPoolDataSource assertCpds() throws SQLException {
        if (this.is_closed) {
            throw new SQLException(this + " has been closed() -- you can no longer use it.");
        }
        ConnectionPoolDataSource out = this.getConnectionPoolDataSource();
        if (out == null) {
            throw new SQLException(NO_CPDS_ERR_MSG);
        }
        return out;
    }

    private synchronized C3P0PooledConnectionPoolManager getPoolManager() throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = C3P0PooledConnectionPoolManager.find(this.getPoolOwnerIdentityToken(), this.assertCpds(), this.getNumHelperThreads());
            this.poolManager.registerActiveClient(this);
            System.err.println("Initializing c3p0 pool... " + this.toString());
        }
        return this.poolManager;
    }
}

