/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry;

import java.io.IOException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.BundleModel;
import org.eclipse.core.internal.registry.ConfigurationElement;
import org.eclipse.core.internal.registry.ConfigurationProperty;
import org.eclipse.core.internal.registry.Extension;
import org.eclipse.core.internal.registry.ExtensionPoint;
import org.eclipse.core.internal.registry.Factory;
import org.eclipse.core.internal.registry.RegistryModelObject;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.ServiceReference;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionsParser
extends DefaultHandler {
    private static long cumulativeTime = 0L;
    private boolean compatibilityMode;
    private Factory factory;
    private String locationName = null;
    private Stack stateStack = new Stack();
    private Stack objectStack = new Stack();
    private Locator locator = null;
    private ServiceReference parserReference;
    private String schemaVersion = null;
    public static final int PARSE_PROBLEM = 1;
    public static final String BUNDLE = "bundle";
    public static final String PLUGIN = "plugin";
    public static final String FRAGMENT = "fragment";
    public static final String BUNDLE_UID = "id";
    public static final String EXTENSION_POINT = "extension-point";
    public static final String EXTENSION_POINT_NAME = "name";
    public static final String EXTENSION_POINT_ID = "id";
    public static final String EXTENSION_POINT_SCHEMA = "schema";
    public static final String EXTENSION = "extension";
    public static final String EXTENSION_NAME = "name";
    public static final String EXTENSION_ID = "id";
    public static final String EXTENSION_TARGET = "point";
    public static final String ELEMENT = "element";
    public static final String ELEMENT_NAME = "name";
    public static final String ELEMENT_VALUE = "value";
    public static final String PROPERTY = "property";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE = "value";
    private static final int IGNORED_ELEMENT_STATE = 0;
    private static final int INITIAL_STATE = 1;
    private static final int BUNDLE_STATE = 2;
    private static final int BUNDLE_EXTENSION_POINT_STATE = 5;
    private static final int BUNDLE_EXTENSION_STATE = 6;
    private static final int CONFIGURATION_ELEMENT_STATE = 10;
    private static final int EXTENSION_POINT_INDEX = 0;
    private static final int EXTENSION_INDEX = 1;
    private static final int LAST_INDEX = 1;
    private Vector[] scratchVectors = new Vector[2];
    private String manifestType;

    public ExtensionsParser(Factory factory) {
        this.factory = factory;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void characters(char[] ch, int start, int length) {
        int state = (Integer)this.stateStack.peek();
        if (state != 10) {
            return;
        }
        if (state == 10) {
            ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.peek();
            String value = new String(ch, start, length);
            String oldValue = currentConfigElement.getValueAsIs();
            if (oldValue == null) {
                if (value.trim().length() != 0) {
                    currentConfigElement.setValue(value);
                }
            } else {
                currentConfigElement.setValue(String.valueOf(oldValue) + value);
            }
        }
    }

    public void endDocument() {
    }

    public void endElement(String uri, String elementName, String qName) {
        switch ((Integer)this.stateStack.peek()) {
            case 0: {
                this.stateStack.pop();
                break;
            }
            case 1: {
                this.internalError(Policy.bind("parse.internalStack", elementName));
                break;
            }
            case 2: {
                Vector extVector;
                if (!elementName.equals(this.manifestType)) break;
                this.stateStack.pop();
                BundleModel root = (BundleModel)this.objectStack.peek();
                Vector extPointVector = this.scratchVectors[0];
                if (extPointVector.size() > 0) {
                    root.setExtensionPoints(extPointVector.toArray(new ExtensionPoint[extPointVector.size()]));
                    this.scratchVectors[0].removeAllElements();
                }
                if ((extVector = this.scratchVectors[1]).size() <= 0) break;
                root.setExtensions(extVector.toArray(new Extension[extVector.size()]));
                this.scratchVectors[1].removeAllElements();
                break;
            }
            case 5: {
                if (!elementName.equals(EXTENSION_POINT)) break;
                this.stateStack.pop();
                break;
            }
            case 6: {
                if (!elementName.equals(EXTENSION)) break;
                this.stateStack.pop();
                Extension currentExtension = (Extension)this.objectStack.pop();
                BundleModel parent = (BundleModel)this.objectStack.peek();
                currentExtension.setParent(parent);
                this.scratchVectors[1].addElement(currentExtension);
                break;
            }
            case 10: {
                this.stateStack.pop();
                ConfigurationElement currentConfigElement = (ConfigurationElement)this.objectStack.pop();
                String value = currentConfigElement.getValueAsIs();
                if (value != null) {
                    currentConfigElement.setValue(value.trim());
                }
                Object parent = this.objectStack.peek();
                currentConfigElement.setParent((RegistryModelObject)parent);
                if ((Integer)this.stateStack.peek() == 6) {
                    IConfigurationElement[] oldValues = ((Extension)parent).getConfigurationElements();
                    int size = oldValues == null ? 0 : oldValues.length;
                    IConfigurationElement[] newValues = new IConfigurationElement[size + 1];
                    int i = 0;
                    while (i < size) {
                        newValues[i] = oldValues[i];
                        ++i;
                    }
                    newValues[size] = currentConfigElement;
                    ((Extension)parent).setSubElements(newValues);
                    break;
                }
                IConfigurationElement[] oldValues = ((ConfigurationElement)parent).getChildren();
                int size = oldValues == null ? 0 : oldValues.length;
                IConfigurationElement[] newValues = new IConfigurationElement[size + 1];
                int i = 0;
                while (i < size) {
                    newValues[i] = oldValues[i];
                    ++i;
                }
                newValues[size] = currentConfigElement;
                ((ConfigurationElement)parent).setChildren(newValues);
            }
        }
    }

    public void error(SAXParseException ex) {
        this.logStatus(ex);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.logStatus(ex);
        throw ex;
    }

    private void handleExtensionPointState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", EXTENSION_POINT, elementName));
    }

    private void handleExtensionState(String elementName, Attributes attributes) {
        this.stateStack.push(new Integer(10));
        ConfigurationElement currentConfigurationElement = this.factory.createConfigurationElement();
        this.objectStack.push(currentConfigurationElement);
        currentConfigurationElement.setName(elementName);
        this.parseConfigurationElementAttributes(attributes);
    }

    private void handleInitialState(String elementName, Attributes attributes) {
        if (elementName.equals(this.manifestType)) {
            this.compatibilityMode = !elementName.equals(BUNDLE);
            this.stateStack.push(new Integer(2));
            BundleModel current = this.factory.createBundle();
            current.setSchemaVersion(this.schemaVersion);
            current.setStartLine(this.locator.getLineNumber());
            this.objectStack.push(current);
        } else {
            this.stateStack.push(new Integer(0));
            this.internalError(Policy.bind("parse.unknownTopElement", elementName));
        }
    }

    protected static String[] getArrayFromList(String line) {
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(line, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.length() == 0) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? null : list.toArray(new String[0]);
    }

    private void handleBundleState(String elementName, Attributes attributes) {
        if (elementName.equals(EXTENSION_POINT)) {
            this.stateStack.push(new Integer(5));
            this.parseExtensionPointAttributes(attributes);
            return;
        }
        if (elementName.equals(EXTENSION)) {
            this.stateStack.push(new Integer(6));
            this.parseExtensionAttributes(attributes);
            return;
        }
        this.stateStack.push(new Integer(0));
        this.internalError(Policy.bind("parse.unknownElement", this.manifestType, elementName));
    }

    public void ignoreableWhitespace(char[] ch, int start, int length) {
    }

    private void logStatus(SAXParseException ex) {
        String name = ex.getSystemId();
        if (name == null) {
            name = this.locationName;
        }
        name = name == null ? "" : name.substring(1 + name.lastIndexOf("/"));
        String msg = name.equals("") ? Policy.bind("parse.error", ex.getMessage()) : Policy.bind("parse.errorNameLineColumn", new String[]{name, Integer.toString(ex.getLineNumber()), Integer.toString(ex.getColumnNumber()), ex.getMessage()});
        this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, msg, ex));
    }

    private SAXParserFactory acquireXMLParsing() {
        this.parserReference = InternalPlatform.getDefault().getBundleContext().getServiceReference("javax.xml.parsers.SAXParserFactory");
        if (this.parserReference == null) {
            return null;
        }
        return (SAXParserFactory)InternalPlatform.getDefault().getBundleContext().getService(this.parserReference);
    }

    private void releaseXMLParsing() {
        if (this.parserReference != null) {
            InternalPlatform.getDefault().getBundleContext().ungetService(this.parserReference);
        }
    }

    public synchronized BundleModel parseBundle(InputSource in, String manifestType) throws SAXException, IOException {
        BundleModel bundleModel;
        block8: {
            SAXParserFactory factory;
            long start = 0L;
            if (InternalPlatform.DEBUG) {
                start = System.currentTimeMillis();
            }
            if ((factory = this.acquireXMLParsing()) == null) {
                return null;
            }
            try {
                if (manifestType == null) {
                    throw new NullPointerException();
                }
                if (!(manifestType.equals(BUNDLE) || manifestType.equals(PLUGIN) || manifestType.equals(FRAGMENT))) {
                    throw new IllegalArgumentException("Invalid manifest type: " + manifestType);
                }
                this.manifestType = manifestType;
                this.locationName = in.getSystemId();
                try {
                    factory.setNamespaceAware(true);
                    factory.setFeature("http://xml.org/sax/features/string-interning", true);
                    factory.setValidating(false);
                    factory.newSAXParser().parse(in, (DefaultHandler)this);
                }
                catch (ParserConfigurationException e) {
                    e.printStackTrace();
                }
                bundleModel = (BundleModel)this.objectStack.pop();
                Object var7_7 = null;
                this.releaseXMLParsing();
                if (!InternalPlatform.DEBUG) break block8;
            }
            catch (Throwable throwable) {
                block9: {
                    Object var7_8 = null;
                    this.releaseXMLParsing();
                    if (!InternalPlatform.DEBUG) break block9;
                    InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
                }
                throw throwable;
            }
            InternalPlatform.getDefault().setOption("org.eclipse.core.runtime/registry/parsing/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
        }
        return bundleModel;
    }

    private void parseConfigurationElementAttributes(Attributes attributes) {
        int len;
        ConfigurationElement parentConfigurationElement = (ConfigurationElement)this.objectStack.peek();
        parentConfigurationElement.setStartLine(this.locator.getLineNumber());
        Vector<ConfigurationProperty> propVector = null;
        int n = len = attributes != null ? attributes.getLength() : 0;
        if (len == 0) {
            return;
        }
        propVector = new Vector<ConfigurationProperty>();
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i);
            ConfigurationProperty currentConfigurationProperty = this.factory.createConfigurationProperty();
            currentConfigurationProperty.setName(attrName);
            currentConfigurationProperty.setValue(attrValue);
            propVector.addElement(currentConfigurationProperty);
            ++i;
        }
        parentConfigurationElement.setProperties(propVector.toArray(new ConfigurationProperty[propVector.size()]));
        propVector = null;
    }

    private void parseExtensionAttributes(Attributes attributes) {
        BundleModel parent = (BundleModel)this.objectStack.peek();
        Extension currentExtension = this.factory.createExtension();
        currentExtension.setStartLine(this.locator.getLineNumber());
        this.objectStack.push(currentExtension);
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtension.setName(attrValue);
            } else if (attrName.equals("id")) {
                currentExtension.setSimpleIdentifier(attrValue);
            } else if (attrName.equals(EXTENSION_TARGET)) {
                String targetName;
                if (attrValue.lastIndexOf(46) == -1) {
                    String baseId = parent.getName();
                    targetName = String.valueOf(baseId) + "." + attrValue;
                } else {
                    targetName = attrValue;
                }
                currentExtension.setExtensionPointIdentifier(targetName);
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", EXTENSION, attrName));
            }
            ++i;
        }
    }

    private void parseExtensionPointAttributes(Attributes attributes) {
        ExtensionPoint currentExtPoint = this.factory.createExtensionPoint();
        currentExtPoint.setStartLine(this.locator.getLineNumber());
        int len = attributes != null ? attributes.getLength() : 0;
        int i = 0;
        while (i < len) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i).trim();
            if (attrName.equals("name")) {
                currentExtPoint.setName(attrValue);
            } else if (attrName.equals("id")) {
                currentExtPoint.setSimpleIdentifier(attrValue);
            } else if (attrName.equals(EXTENSION_POINT_SCHEMA)) {
                currentExtPoint.setSchema(attrValue);
            } else {
                this.internalError(Policy.bind("parse.unknownAttribute", EXTENSION_POINT, attrName));
            }
            ++i;
        }
        BundleModel root = (BundleModel)this.objectStack.peek();
        currentExtPoint.setParent(root);
        this.scratchVectors[0].addElement(currentExtPoint);
    }

    public void startDocument() {
        this.stateStack.push(new Integer(1));
        int i = 0;
        while (i <= 1) {
            this.scratchVectors[i] = new Vector();
            ++i;
        }
    }

    public void startElement(String uri, String elementName, String qName, Attributes attributes) {
        switch ((Integer)this.stateStack.peek()) {
            case 1: {
                this.handleInitialState(elementName, attributes);
                break;
            }
            case 2: {
                this.handleBundleState(elementName, attributes);
                break;
            }
            case 5: {
                this.handleExtensionPointState(elementName, attributes);
                break;
            }
            case 6: 
            case 10: {
                this.handleExtensionState(elementName, attributes);
                break;
            }
            default: {
                this.stateStack.push(new Integer(0));
                this.internalError(Policy.bind("parse.unknownTopElement", elementName));
            }
        }
    }

    public void warning(SAXParseException ex) {
        if (!this.compatibilityMode) {
            this.logStatus(ex);
        }
    }

    private void internalError(String message) {
        if (this.compatibilityMode) {
            return;
        }
        if (this.locationName != null) {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, String.valueOf(this.locationName) + ": " + message, null));
        } else {
            this.factory.error(new Status(2, "org.eclipse.core.runtime", 1, message, null));
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (target.equalsIgnoreCase("eclipse")) {
            this.schemaVersion = "3.0";
            StringTokenizer tokenizer = new StringTokenizer(data, "=\"");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!token.equalsIgnoreCase("version")) continue;
                if (!tokenizer.hasMoreTokens()) break;
                this.schemaVersion = tokenizer.nextToken();
                break;
            }
        }
    }
}

