#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------

# unix.py
# (C) 2006 M. Andreoli
# unix-like commands for the interactive session
# Partially borrowed from PUTOOLS (init_globals() and listdir()). 
#  

# Note1: args policy is not the standard Unix. In f(*args), the command 
# name is NOT passed.
# Note2: each commands read and write on stdin and stdout. When runs in
# on network connections, read() and write() will be redirect to the
# network socket wrapper (see stream.py) 



__all__ = [ 'cat', 'cd', 'less', 'ls', 'mkdir', 'more', 'pwd',
	    'dirname','basename','cp','du','find','grep',
	    'ping','man','wget','date',
	    'put','tx','rx','echo','list','hello',
            'rm', 'run','credits','vi',
            'rsh','reval',
	    ]

global self	# instance of the Shell class

def __init__(shell):
	global self 
	self=shell
	print "inizializing unix extensions ..."

import os,sys,string
from misc import * 
from shell import HOME
from ext import glob


try:
	import e32
except:
	e32=''

# os.walk() is not supported on the Symbian v2.2 Python
# this is the workaround

try:
	dummy=dir(os.walk)
	walk=os.walk
except:
	walk=my_walk

try:
	os.chdir( HOME )
except:
	pass

run_globals = dict( globals() )
run_globals['__name__'] = '__main__'

def init_globals( d ):
    """create a dictionary that is used as global dictionary with the run command
    so the run works as expected (with fairly clean namespace, __name__ = __main__, etc.
    """
    global run_globals
    run_globals = dict( d )
    run_globals['__name__'] = '__main__'
    

#-------------------
# UNIX extensions
#-------------------
	
def vi(*args):
	"""
	vi - call the vi editor on the client machine
	Usage:
		vi [-n] [filename]	

	Options:	
		-n 	create the file, if not existent
	
	NB: works trasferring the file on the client, than
	again on the server

	"""
	
	if len(args)==0:
		man('vi')
		return
	n_opt=0
	if args[0]=='-n':
		args=args[1:]
		n_opt=1

	F=parse(args); filename=F[0]

	if not os.path.isfile(filename):
		if not n_opt:
			print "file %s not existent." %filename
			print "Please, use the -n option if you want create it."
			return
		else:
			f=open(filename,'w+')
			f.close()	

	name=os.path.basename(filename)

	# check the remote system type
	rp=remote_platform()
	print "remote_platform[%s]" % rp
	if rp.find('linux')>=0:
		tmpdir='/tmp'
		remote=tmpdir+"/"+name
		editor='vi'
	else:
		tmpdir='c:\\tmp'
		remote=tmpdir+"\\"+name
		editor='edit'

	tx(filename,tmpdir)
	rsh("%s %s" % (editor,remote))

	#r=input("do you want save %s [y/n]? > "%filename,1)
	r='y'
	if r=='y':
		rx(remote,filename)
		print "saved"
	elif r=='n':
		print "any changes are (eventually) lost"


def btconnect(port=None):
	import socket

	sock = socket.socket(socket.AF_BT,socket.SOCK_STREAM)

	print "please, look to the phone device ..."
        address,services = socket.bt_discover()
        print "Discovered: %s, %s"%(address, services)

	if port==None:
        	port=services.values()[0]
        target = (address, port)
		
	sock.connect(target)
	print "connected to %s" % repr(target)
	

def reval(*args):
        """
        reval - evaluate python commands on the remote client
		WARNING: the command MUST return something, or
		the program will BLOCKS!

        usage:
                reval cmd       # remote command [cmd]
        examples:
                rsh import sys; sys.platform     # execute the remote interactive UNIX shell
        """

        cmd=string.join(args)
        if len(cmd)==0:
                man('reval')
                return

        sys.stdout.write('EVAL|%s|' % cmd)
       	line=sys.stdin.read()
	nl=sys.stdin.read()	# read the \n
	sys.stdout.write(line)
	sys.stdout.write(nl)
	# the python interpreter return additional double-quoting
	return line[1:-1] 

def rsh(*args):
	""" 
	rsh - execute remote commands on the remote client 
	usage:
		rsh [cmd]	# remote command [cmd]
	examples:
		rsh bash	# execute the remote interactive UNIX shell
	"""

	cmd=string.join(args)
	if len(cmd)==0:
		man('rsh')
		return
	
	sys.stdout.write('SYSTEM|%s|' % cmd)
	
def rx(rem,loc=None):
	"""
	usage:
		rx remote_file local_file
		rx remote_file local_dir 
		rx remote_file 	(assume local_dir=cwd) 

	See also: tx

	"""

	if loc==None: loc='.'
	

	loc=(parse([loc]))[0]

	if os.path.isdir(loc):
			loc=os.path.join(loc, os.path.basename(rem))

	# ask for the file
	sys.stdout.write( 'RETR|%s|' %rem )
	# receive the file
	if sys.stdin.recfile(loc):
		size=os.path.getsize(loc)/1024
		print "received %s ( %d K)" %(loc,size) 
		
def tx(*args):
        """
	tx: trasmit a file from the local to the remote (client) system

        usage:
                tx local_files* remote_dir
		
	Examples:

		tx x /tmp
		tx abc	. # current directory in the remote side 
		tx abc	# ERROR!
		tx *.ps /home/michele/tmp
		tx E:\\img\\*.jpg  /home/michele/nokia
		

	Note:
        	*) local means on the server; remote, on the client
		*) NOTE!NOTE! remote_dir should exists on the client-side.

        See also: rx

        """
	
        if len(args)<=1:
                man('tx')
                return 0

	remote=args[-1];

	args=args[:-1]
        F=parse(args)

	for x in F:
		if os.path.isfile(x):
			filename=os.path.basename(x)
			size=os.path.getsize(x)/1024
			sys.stdout.write( 'STOR|%s|%s' % (filename,remote) )
			if sys.stdout.sendfile(x):
				print "sent %s -> %s (%d K)..." %(x,remote,size)

		else:
			print "skipping %s" % x

#----------------------
# SPECIAL commands
#----------------------

def credits(*args):
	print "pyfs: (C) 2006-2007, Michele Andreoli - Italy luogosano@gmail.com"
	print "http://mulinux.sunsite.dk/pyfs/"

# obsolete
def upgrade(*args):
	"""
	software upgrade 
		upgrade files ... (no path, no wildcards)
		upgrade	
	(internal use only: DISABLED)
	"""
	if sys.platform.find("symbian")<0:
		print "only work for Nokia Py60"
		return

	SRC="/home/michele/devel/pyfs/"
	DST="E:\\system\\apps\\pyfs\\"

	if len(args)==0:
		man('install')
		return
	for m in args: 
		(SRC+m,DST+m)
		

def ping(arg):
	sys.stdout.write('PING|%s|' % arg) 
	rc=sys.stdin.read()
	print "server: received : [%s]" % rc 

def hello(*args):
        """
	Simple GUI demo (hello world) for various
	platforms: Symbian (py60), Linux (wxPython), Windows
	and XBOX (xbmcgui)

        """

	if sys.platform.find("symbian")>=0:
		try:
			import appuifw
		except:
			trace("appuifw python module is required. Abort")

		list = [u"Hello", u"World!", u"...."]
		item = appuifw.popup_menu(list, u"Select + press OK:")
		appuifw.note("You select [%s]"% list[item], "info")
	elif sys.platform.find("linux")>=0:
		try:
			import wx 
		except:
			trace("wx python module is required. Abort")

		App=wx.App()
		d=wx.MessageDialog(None,u"Hello, world!")
		d.ShowModal()
		d.Destroy()
	elif sys.platform.find("win32")>=0:
		try:
			import Tkinter
		except:
			trace("Tkinter python module is required. Abort")

		root = Tkinter.Tk()
		Tkinter.Button(root, text='Hello World!', command=sys.exit).pack()
		root.mainloop()
	else:
		print "user interface API for platform %s unknown, sorry" % sys.platform




#----------------------
# SHELL commands
#----------------------



def man(page=''):
        """
        man - manual pages
        Usage:
                man
                ... or ...
                man command

        """
        if len(page)==0:
                n=0
                print "Availables commands:"
                print
                list=self.commands.keys(); list.sort()
                for c in list:
                        print  "%10s" % c,
                        n=n+1
                        if n % 3==0:
                                print
                print
                return


        if  not self.commands.has_key(page):
                print "command %s doesn't exists yet" % page 
                return

        if  self.commands[page].__doc__:
                print self.commands[page].__doc__
        else:
                print "command %s  doesn't have a man entry" % page 


# unix date 

def date(*args):
        """
        date: print the system date 

        usage:
               	date 


        """
        try:
                import time 
        except:
                trace("python module time is missing. Abort")
                return

	print time.asctime ( time.localtime() )

# retrieve files using URLLIB

def wget(*args):
	"""
	wget: download files, over the net
 
	usage:
		wget url1 url2 .... 

	Example:
		wget http://www.google.it/  c
 
	"""
	try:
		import urllib
	except:
		trace("python module urlib is missing. Abort")
		return

	def reporthook(*a): print a
	for url in args:
     		i = url.rfind('/')
     		file = url[i+1:]
		if len(file)==0:
                	file="index.html"

     		print url, "->", file
     		urllib.urlretrieve(url, file, reporthook)


def find(filepattern, base = '.'):
	"""
	find: find a file 
	usage:
		find regex-pattern directory 

	Example:
		find .*.ps /tmp
		find ca??hio.jpg /tmp
	"""
	try:
		import re
	except:
		trace("python module 're' is missing. Abort")
		return

	if len(filepattern)==0:
		man('find')
		return	

	regex = re.compile(filepattern)
	matches = []
	for root,dirs,files in walk(base):
        	for f in files:
          		if regex.match(f):
				found=os.path.join(root,f)
				print "%s" % found



def grep(*args):
        """
        grep: searching string (regex) in a file
        usage:
                grep [-i] pattern file 

	notes:
		-i : case insensitive search

        Example:
                grep ca??hio.jpg imglist.txt 
                grep ^http:.*.html list.txt 
                grep the end$ list.txt 
        """
	try:
		import re
	except:
		trace("python module 're' is missing. Abort")
		return

	# syntax:

	sensitive=True
	if args[0]=='-i':
		sensitive=False	
		args=args[1:]	


	if len(args) < 2:
		man("grep")
		return
	#ok

	pattern=args[0]
	filename=(myglob(args[1]))[0]

	#print "grep: pattern[%s], filename=[%s]" % (pattern, filename)

	if sensitive:
        	regex = re.compile(pattern)
	else:
        	regex = re.compile(pattern,re.IGNORECASE)
		
	try:
		f=open(filename,"r")
	except:
		trace("impossible to open %s" % filename)
		return

        for line in f:
		#print "check [%s] against [%s] ..." %(line[:-1],pattern)
                #if regex.match(line):
                if regex.search(line):
                	print "%s" % line 
	f.close()

def dirname(*args):
	"""
	dirname: return the directory part of the path
	usage:
		basename file 
	"""
	F=parse(args)
	print "%s" % os.path.dirname( F[0])


def basename(*args):
	"""
	basename: return last part of the path
	usage:
		basename file 
	"""
	F=parse(args)
	print "%s" % os.path.basename( F[0])

	
def echo(*args):
	"""
	usage:
		echo strings ... 
	"""
	print  string.join(args,' ')


# syntax: cp_file file -> file|dir 
# no recursion, here
# return the number of bytes copied

def cp_file(*args):
       # syntax
        F=args
	# NO GLOBBING here
        if len(F)<2:
               	print "err: cp_file x y"
		return 0

        first=F[0]; last=F[1]

	base=os.path.basename(first)
	dirname=os.path.dirname(first)

        # the first is a file?
        if os.path.isfile(first)==False:
		print "omitting directory %s" %first
		return 0 

	try:
               	r=open(first,'rb') 
	except:
		print "impossible to read %s" %first
		return 0 


       	if os.path.exists(last)==True:
       		if os.path.isdir(last)==True:
			last=os.path.join(last,base)
				
	try:
               	w=open(last,'wb')
	except:
		print "impossible to create %s" % last
		return 0 

	# copy the files
	bsize=8192; size=0
	while 1:
		content=r.read(bsize);
		if len(content)==0:
			break
		size=size+len(content)
        	w.write( content )
	r.close()
        w.close()
        #print "copied %s to %s, %d bytes" %(relative(first),last,size)
        del content
	return size


# cp with walk()
#-------------------

def cp(*args):
	"""
        usage:
                cp file1 file2 
                cp files*   dir
                cp [-r] files* dirs*  dir
	note:
		-rr more verbose

        """
	F=parse(args)
	recursive=False
	verbose=False

	if F[0]=='-r': 
		recursive=True
		mode=F[0]; del F[0]
		
	if F[0]=="-rr":
		recursive=True
		verbose=True
		mode=F[0]; del F[0]

	if len(F)<2:
		man('cp')
		return 0


	if verbose:
		print "cp: F=%s" % repr(F)

	last=F[-1]
	F=F[:-1]


	size=0; nfiles=0; ndir=0

	for top in F:
		# top is a single files ...
		if os.path.isfile(top):
			size+=cp_file(top,last)
			nfiles+=1	
			continue

		# top is a directory
                if not recursive:
                        print "skipping directory %s" %top
			continue

		if not os.path.isdir(last):
			os.mkdir(last)
			if verbose:
				print "created dir %s" % last
			parent=top
			ndir+=1
		else:
			parent=os.path.dirname(top)
			# the root of fs?
			if os.path.dirname(parent)==parent:
				try:
					last+=os.path.sep
				except:
					last+="\\"
		# Ok, walk

		for root,dirs,files in walk(top):
			# create the subdirs
			r=root.replace(parent,last)
			if not os.path.isdir(r):
				try:
					os.mkdir( r )
					if verbose:
						print "created dir %s" %r 
					ndir+=1
				except:
					trace("making dir %s" % r)
			# copy the files
			for f in files:
				x=os.path.join(root,f)
				y=os.path.join(r,f)
				size+=cp_file(x,y)	
				if verbose:
					print "%s --> %s" % (x,y)
				nfiles+=1

	print "copied %d files, %d bytes" %(nfiles,size)	

def put( *args ):
	"""
	put - output string (from stdin) on a file 

	DOESN'T WORKS, because readline() on w32 ...

	USAGE:
		put file
	"""
	filename=args[0]	
        #content=sys.stdin.readline()
        content=raw_input()
	try:
		f=open(filename,'wb')
		f.write(content)
		f.close()
	except:
		trace("problem writing on [%s]") %filename		


	
def cat( *args ):
	"""
	cat - concatenate files and print on the standard output
	USAGE:
		cat files ...
	"""
	A=parse(args)
	for name in A:
		if os.path.isfile(name):
            		print open( name, 'r' ).read()
   		else:
            		print '"%s" is not a file' % name 
		
        
less = cat
more = cat

def cd( *args ):
    """
    NAME
       cd - change directory

    SYNOPSIS
       cd [DIRECTORY]

    DESCRIPTION
       Change current directory to DIRECTORY.
       If no DIRECTORY is given, goes to HOME (the Python installation directory).

    NOTE
      For win32: use 
			cd E:\    not cd e:\, or cd e:, etc

    """
    A=parse(args)

    try:
        if len(A) == 1:
	    d=A[0]
	    if os.path.isdir(d)==False:
		print "directory not exists: [%s]" %d
		return	
            os.chdir( A[0] )
        elif len(A) == 0:
    	    os.chdir( HOME )    
        else:
    	    man('cd'); return    
        print 'current directory:', os.getcwd()
    except:
        trace( 'cd failed' )

def printdir( d, files ):
    o=""
    if d:
        o='%s:\n'% d

    if files:
        # add a slash to all directories
        for i in range(len(files)):
            if os.path.isdir(files[i]):
                files[i] += '/'
        # how wide columns?
        n = max( [ len(f) for f in files ] ) + 2
        # how many columns?
        ncols = 80 / n
	#if sys.platform.find("symbian") >=0:
        #	ncols = 30 / n
        # how many rows per column?
        nrows = (len(files)+ncols-1) / ncols
        files.extend( ['']*(nrows*ncols - len(files)) )

        # split entries into columns
        cols = []
        while files:
            cols.append( files[:nrows] )
            files = files[nrows:]

        # find out how long each column should be
        colwidth = []
        for col in cols:
            colwidth.append( max( [len(f) for f in col] ) + 1 )

        # print one row at a time
        for i in range(nrows):
            for j in range(ncols):
                o+=cols[j][i].ljust( colwidth[j] )
            o+='\n' 
        #o+='\n' 
    else:
        o=o+'<empty directory>'+'\n' 
    sys.stdout.write(o)

def glob_entries( str ):
    """ str may contain several entries with wild cards, return two lists,
    the first being files and second directories matched by the entries
    """
    # glob all the entries
    entries = []
    for e in str.split( ' ' ):
        entries.extend( glob(e) )
    # sort them to files vs. dirs
    files = []
    dirs = []
    for e in entries:
        if os.path.isdir( e ):
            dirs.append( e )
        elif os.path.isfile( e ):
            files.append( e )
    return files, dirs

    
def ls( *args ):
    """
    NAME
       ls - list directory contents

    SYNOPSIS
       ls [FILE]...

    DESCRIPTION
       List files in a path. Wildcards (*, ?) are allowed.
       If no arguments are given, lists the content of the current directory.
    """
    
    try:
        # get the files
        if len(args) == 0:
            # just ls
            printdir( '', os.listdir( norm(os.getcwd())  ) )
        else:
    	    F=parse(args)
	    files, dirs = glob_entries( string.join(F) )
            if files:
                # show the files
                files.sort()
                printdir( '', files )
            if dirs:
                if files or len( dirs ) > 1:
                    # not just a single directory, show directory name and contents
                    dirs.sort()
                    for d in dirs:
                        printdir( d, os.listdir( norm(d) ) )
                else:
                    # just a single directory, list it
		    print "list of [%s]" % dirs[0]
                    printdir( '', os.listdir( norm(dirs[0]) ) )

    except:
        trace( 'ls failed' )


def du(*args):
	"""
	du:  disk usage 
	USAGE:
		du files* dirs*	
	"""	

	if len(args)==0:
		print 'no arguments'
		man('du')
		return

	s=0; nf=0
	F=parse(args)
	for a in F:

		i=0
		for root,dirs,files in walk(a):
			i+=1
			for f in files:
				ff=os.path.join(root,f)
				if os.path.isfile(ff):
					sf=os.path.getsize(ff)
					s+=sf
					nf+=1
					#print "file %s, size %d" %(ff,sf)
		if i==0:
			if os.path.isfile(a):
				nf+=1
				s+=os.path.getsize(a)
				
	print "total %d Mb ( %d bytes in %d files)" % (s/(1024.0*1024.0),s,nf)



def mkdir( *args  ):
    """
    NAME
       mkdir - make directories

    SYNOPSIS
       mkdir DIRECTORY...
 if they do not already exist.
    """
    try:
	dir = norm(args[0])
	parent=os.path.dirname(dir)
		
	if os.path.isdir(parent):
        	if os.path.isdir( dir ):
			# directory existes, ok, silence
                    	print "directory %s exists" % dir
			pass
                else:
                	if os.path.isfile( dir ):
                    		print "mkdir: '%s' exists but is not a directory" % dir
				return
			else:
				os.mkdir(dir)
                    		print "%s created" % relative(dir)
	else:
		print "please: create %s first" % parent
        	#mkdir( parent )
		#mkdir( dir )
    except:
        trace( 'mkdir failed' )

def pwd( *args ):
    """
    NAME
       pwd - print name of current/working directory

    SYNOPSIS
       pwd

    DESCRIPTION
       Print name of working directory.
    """
    print os.getcwd()



# rm recursive

def rm(*args):
        """
        NAME
        rm [-r] files* dir*

	note:
        	-r means recursively remove
		-rr recursive and verbose
        	Wildcards * allowed
        """

        recursive=False
	verbose=False

        if args[0]=="-r":
                recursive=True
		mode=args[0]
                args=args[1:]
        if args[0]=="-rr":
                recursive=True
		verbose=True
		mode=args[0]
                args=args[1:]

        if len(args)<1:
                man('rm')
                return

	F=parse(args)
	nfiles=0; ndirs=0

        for top in F:
                # top is a single files ...
                if os.path.isfile(top):
			try:
				os.unlink(top)
                        	nfiles+=1
				if verbose:
					print "removed (%5s) %s" % ("file",top)
			except:
				trace("removing the file %s" %top)
				continue

                # top is a directory

                if not recursive:
                        #print "please, use -r to remove %s" %top
                        continue

                # get the directory list
 
		list=os.listdir(top)

		# the directory contains some files ...

                for f in list:
			ff=os.path.join(top,f)
			if os.path.isfile(ff):
				try:
					os.unlink(ff)
                               		nfiles+=1
					if verbose:
						print "removed (%5s) %s" % ("file",ff)
				except:
					trace("removing the file %s" %ff)
					continue	
			else:
				# recursion starts
				rm(mode,ff)
                                ndirs+=1

		# now, remove the top
		try:
			os.rmdir(top)
			if verbose:
				print "removed (%5s) %s" % ("dir",top)
			ndirs+=1
		except:
			trace("impossible to remove %s" %top)

        print "removed %d files, %d directories" %(nfiles,ndirs)

def list(*args):
        """
        NAME
        list files* dir*

	note:
		recursive
        	Wildcards * allowed
        """

        recursive=True
	verbose=False

        if len(args)<1:
                man('rm')
                return

	F=parse(args)

	nfiles=0; ndirs=0

        for top in F:
                # top is a single files ...
                if os.path.isfile(top):
			print "(%5s) %5d K %s" %("file",os.path.getsize(top)/1024,top)
                        nfiles+=1
			continue

                # top is a directory
                if not recursive:
                        #print "please, use -r to remove %s" %top
                        continue

                # Ok, walk

                for root,dirs,files in walk(top):

                        # rm the files
                        for f in files:
                                ff=os.path.join(root,f)
				print "(%5s) %9d K %s" %("file",os.path.getsize(ff)/1024,ff)
                                nfiles+=1
                        for d in dirs:
                                dd=os.path.join(root,d)
				print "(%5s) %9s K %s" %("dir",'?',dd)
                                ndirs+=1

		# now,  the top
		print "(%5s) %9s K %s" %("dir",'?',top)
                ndirs+=1

        print "%d files, %d directories" %(nfiles,ndirs)

def run(*args):
	"""
	run a python files
	USAGE:
		run file.py
		run z:\\system\\apps\\calendar\\calendar.app
		etc ...
	"""
	apprun="z:\\system\\programs\\apprun.exe";
	lock=e32.Ao_lock()
	
	cmd=args[0]

	if len(cmd)==0:
		man('run')
		return

	#print "app=%s wait=%d\n" %(app,wait)
	
        if os.path.isfile(cmd) == False:
		print "file not found: %s" % cmd 
		return

	import re

	# backup UI environment
	oldBody=None
	try:
		from appuifw import app	
		#print "backup UI ..."
		oldBody = app.body
		oldExit = app.exit_key_handler
		oldFocus =app.focus
		oldMenu = app.menu
		oldScreen = app.screen
		oldTitle = app.title
	except:
		pass

	if re.search(".*\.py$", cmd) or re.search(".*\.pyc$", cmd) :	
		# try as python script
		save=(sys.stdin,sys.stdout)
       		execfile(cmd, globals())
		(sys.stdin,sys.stdout)=save
		e32.ao_yield()	
	elif re.search(".*\.exe$", cmd):	
			e32.start_exe(apprun, cmd)
	elif re.search(".*\.app$", cmd):	
			e32.start_exe(apprun, cmd)

	# restore UI environment

	if oldBody != None:
		app.body = oldBody
		app.exit_key_handler = oldExit
		app.focus = oldFocus
		app.menu = oldMenu
		app.screen = oldScreen
		app.title = oldTitle
