#!/usr/bin/env python

#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------

# server.py
# (C) 2006 Michele Andreoli
#     

# Usage:
#  	server.py [BT|TCP] [port]
# Notes:
# Default: If platform is Symbian, server.py starts in BT (bluetooth mode), port=5.
# Otherwise, mode=TCP, port=81

clean_builtins=__builtins__

import sys,time,os
import traceback


from stream import Stream
from misc import trace, remote_platform 
from shell import Shell

shell_prompt='>> ' 

#--------------------------
# class Server 
#--------------------------

class Server:
	"""
	Usage:  Server(mode='BT|TCP',port,verbose=0|1)
	"""
	def __init__(self,mode=None,port=None,verbose=0):
		self.verbose=verbose
		self.prompt=shell_prompt
		self.shutdown=False
		self.mode=mode
		self.port=port
		self.conn=Stream(verbose=verbose,mode=mode)
		try:
        		import readline
		except:
        		try:
                		sys.exc_clear()
        		except:
                        	pass
	def run(self):
		global __builtins__
		while not self.shutdown:
		
		        try:
		                # starts the server
		                self.conn.accept(port=self.port)
		        except:
		                #print "server.py: conn.accept() exception"
		                trace("server.py: conn.accept() exception")
		                #traceback.print_exc()
		                break
		
		        # redirect IO
		        save=(sys.stdin,sys.stdout)
		        sys.stdin=self.conn; sys.stdout=self.conn
		        # banner
		        print "Server: %s; Client: %s " % (sys.platform,remote_platform());
		        print "Python version: %s" % sys.version
		        print
		
		        shell=Shell(verbose=0)
		        try:
		                bt=__builtins__
		                __builtins__=clean_builtins
		                shell.run()
		                __builtins__=bt
		        except:
		                print "server.py: shell.run() exception"
		                traceback.print_exc()
		                shell.cmd_exit()
		                del shell
		
		        # restore standard IO
		        (sys.stdin,sys.stdout)=save
		        # close the client
		        self.conn.client.close()

		# finish
		sys.stderr.write("server finished.\n")
		self.conn.shutdown()



#--------------------------
# MAIN
#--------------------------


if __name__ == '__main__':
	# syntax check	
	if len(sys.argv)<3:
		print "pyfs,server.py"
		print "Usage:"
		print "\tserver.py BT|TCP port"
		sys.exit()
	
	mode=sys.argv[1]
	port=int(sys.argv[2])

	# start the server
	server=Server(mode,port)
	server.run()

# End
