#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------

# nokia.py
# (C) 2006 M. Andreoli
# command specifics for the Symbian 60 Nokia phones series 


__all__ = [ 'info','dial','contacts', 'sms', 'say',
		'say_',
		'play','webcam','photo','cam','screenshot',
		'edit','motion'
          ]

import os, sys, string,time
from misc import trace,parse,input,norm 
from unix import man,tx,rm

try:
	import audio
	audio_say=audio.say
except:
	audio_say=trace

def sms(recipient,*args):
	"""
	sms - SMS send
	Usage:
		sms tel message
	"""
	try:
		import messaging 
	except:
		trace("Nokia module required")
		return
	
	if len(args)<1:
		man('sms')
		return

	message=string.join( args,' ')
	messaging.sms_send(recipient,message)
	
def contacts(name=''):
	"""
	contacts - show phone contacts data base 
	
	Usage:
		contacts
		contacts name
	"""
	try:
		import contacts 
	except:
		trace("Nokia module required")
		return

	db=contacts.open()
	list=[]
	if name!='':
		list=db.find(name)
	if len(list)==0:
		list=db.values()
	for contact in list:
		print "%3d: " %contact.id,
		for field in contact:
			print "%10s=%18s " %(field.type,field.value),
		print


# Nokia speech syntesis

def say(*args):
	"""
	say: 	Nokia speech syntesis.
	Usage:
		say string 
	"""

	if len(args)<=0:
		print "missing sentence"
		return
	msg=string.join(args,sep=' ')
	audio_say( msg )

def say_(n):
	"""cb with sound: internal usage	"""
	say(str(n))	

def dial(num):
	"""
	dial: 	dial a number.
		Nokia command
	Usage:
		dial number
	"""
	try:
		import telephone 
	except:
		trace("error loading Nokia modules")
		return
	
	telephone.dial(num)
	
def info(*args):
	"""
	info:	print basic phone info (Nokia only)
	"""
	try:
		import location
		import sysinfo
	except:
		trace("error loading Nokia modules")
		return

	print "%22s: %s" % ("IMEI"  ,sysinfo.imei() ) 
	print "%22s: %s" % ("OS"  , sysinfo.os_version() ) 
	print "%22s: %s" % ("country/network/area"  ,location.gsm_location() ) 
	print "%22s: %d" % ("battery"  , sysinfo.battery() ) 
	print "%22s: %d/%d" % ("RAM"  , sysinfo.free_ram(),sysinfo.total_ram() ) 
	print "%22s: %s" % ("disks"  , repr( sysinfo.free_drivespace()) ) 
	print "%22s: %d" % ("signal level"  , sysinfo.signal() )
	print "%22s: %s" % ("resolution"  , repr(sysinfo.display_pixels()) )


def webcam(*args):
	"""
	webcam -	screenshots using the Nokia camera 
	Usage:
		webcam	[-max max | 1]
			[-p position|0] [-d remotedir|/tmp/webcam]
			[-i interval|0 ] [-s size| 160x120]
			[ -f format ]
	Note 1	
	max is the max number of allowed screenshots. 0 for infinite,
	remotedir is the directory (in the client-side) where the file is trasferred.
	Specify interval (in secs) between screenshots
	position=0,1 is the camera position.
	format is the string-formatter for the filename. Default webcam-%d%m%Y%H%M%S.jpg

	Note 2
	Normally, the image is transferred to the client and removed.
	Unless remotedir=''.

	Examples:
		webcam -s 640x480 	# single photo
		webcam -max 2 -p 1	# two photo, from frontal camera

		webcam -max 0 -i 5 -p 0 
		webcam -max 0 -i 1 -d /path/to/mydir -f current-image.jpg

	"""


	# default values for options 

	position=0
	interval=0
	remotedir='/tmp/webcam'
	size=(160,120)
	format="webcam-%d%m%Y%H%M%S.jpg"
	max=1

	# parse the options

	i=0; ix=len(args)-1
	while i<=ix:
		#print "check args[%d]=%s" % (i,args[i])
		if args[i]=='-p':
			i+=1
			position=int(args[i])	
		elif args[i]=='-s':
			i+=1
			a=args[i].split('x')
			size=( int(a[0]),); size=size+ (int(a[1]),)
		elif args[i]=='-i':
			i+=1
			interval=int(args[i])	
		elif args[i]=='-max':
			i+=1
			max=int(args[i])	
		elif args[i]=='-d':
			i+=1
			remotedir=args[i]	
		elif args[i]=='-f':
			i+=1
			format=args[i]	
		else:
			i+=1

	print "remotedir=%s, filename=%s, camera position %d, " \
	%(remotedir, format, position),
	print "interval=%d, size=%s, max=%d" %(interval,size,max)

	# load Nokia modules

	try:
		import camera 
		import e32
	except:
		trace("error loading Nokia modules")
		return

	n=1
	while 1:
		name=time.strftime(format)
		filename=norm(name)
		e32.ao_yield()
		print "capture #%d" %n

		try:
			image=camera.take_photo(size=size,position=position)
		except:
			trace("take_photo")
			return
		image.save(filename)
		del image
		if len(remotedir)!=0:
			tx(filename,remotedir)
			rm(filename)
		e32.ao_yield()

		n+=1
		if n>max:
			break
		else:
			e32.ao_sleep(interval)


# special cases of webcam()


def cam(max=10):
	"""
	cam -	personal use only 
	"""


	webcam('-d','/srv/www/htdocs/reserved/webcam',\
		'-f','webcam.jpg','-max',max,'-i',1)


def photo(filename="img-%d%m%Y%H%M%S.jpg"):
	"""
	photo 
	Usage:
		photo [filename]

	"""

	webcam('-d','','-f',filename,'-max',1,'-i',0)

def screenshot(filename="e:\\Images\\shot.jpg"):
        """
	screenshot: copy of the phone screen
        Usage:
                screenshot [filename]

        """

	try:
		import graphics
	except:
		trace("graphics module is required")
		return
	image=graphics.screenshot()
	image.save(filename)
	del image
	print "saved in %s" % filename

def edit(filename=None):
        """
        edit - text editor 
        Usage:
                edit filename
	(requires Symbian
	author: Lasse O. Huovinen
	 )
        """
        try:
		import edit
        except:
                trace("problem loading edit.py")
                return


	e=edit.my_app()
	if filename!= None:
		print "opening %s" % filename 
		e.filename=filename
		e.run(filename)
	else:
		e.run()


def motion_cb_audio():
	import audio
	audio.say("fermo")
def motion_cb_sms():
	import location
	global phone
	msg="Video Alarm:\nDATE:"+time.asctime(time.localtime())
	msg=msg+"\nCELL:"+str(location.gsm_location())
	print "sms to %s, msg=[%s]" %(phone,msg)
	sms(phone,msg)
	
def motion(*args):
        """
        motion - simple motion detector 

        Options:
		-t n			(threshold, default=1)
		-audio 			(audio alarm)
		-sms phone_number 	(sms alarm)
        """
        try:
                import motion 
        except:
                trace("problem loading motion.py")
                return

	global phone
	# default
	t=1
        cb=motion_cb_audio
	# parse the options

        i=0; ix=len(args)-1
        while i<=ix:
                #print "check args[%d]=%s" % (i,args[i])
                if args[i]=='-t':
                        i+=1
                        t=int(args[i])
                elif args[i]=='-audio':
                        i+=1
                        cb=motion_cb_audio
                elif args[i]=='-sms':
                        cb=motion_cb_sms
                        i+=1; phone=args[i]
			i+=1
                else:
                        i+=1

	m=motion.Motion(threshold=t,callback=cb)
	m.run()

def play(*args):
	"""
	play - Nokia (native)  media player
	Usage:
		play file*
	"""

	if len(args)==0:
		man('play')
		return

	from appuifw import Content_handler
	c=Content_handler()

	F=parse(args)
	for f in F:
                try:
                        print "playing of [%s] started ..." %f
			c.open(f)
                except:
                        trace("opening file %s" %f)
                        return


# (disabled)

def play_old(*args):
	"""
	play - Nokia  media player
	Usage:
		play file
	"""

	if len(args)==0:
		man('play')
		return

	F=parse(args)
	for f in F:
		try:
			p=audio.Sound.open(f)
			p.play()
			print "playing of [%s] started ..." %f
		except:
			trace("opening sound file %s" %f)
			return
		
		r=input("write 1 to stop playing; 0 otherwise > ",1)
		#sys.stdout.write("KEYB|1")
		#r=sys.stdin.read()
		if r=='1':
			try:
				p.stop()
				print "stopped."
			except:
				trace("stopping the player")
			p.close()


if __name__ == "__main__":
	print "main"
