# motion.py
# (C) 2007 M. Andreoli


from appuifw import *
from graphics import Image
import camera, e32
import audio
import struct, zlib



class Motion:
	def __init__(self,threshold=1, callback=None):
		self.vote=0			# number of events
		self.threshold	= threshold	# max events without signalling
		self.last = '\x00' * 930    # can be anything
		if callback == None:
			self.callback=self.default_callback
		else:
			self.callback=callback

		self.running=True;
		self.lock=e32.Ao_lock();
		self.body=app.body 	# save app.body
		self.exit_key_handler= app.exit_key_handler
		
		# init UI
		app.body=Canvas()
		app.exit_key_handler=self.quit
		
	def quit(self):
		self.running=False;
		#self.lock.signal()
		app.body=self.body
		app.exit_key_handler=self.exit_key_handler

	def default_callback(self):
		audio.say("fermo")

 
	def getdata(self, im, bpp=24):
    		im.save('D:\\pixels.png', bpp=bpp, compression='no')
    		f = open('D:\\pixels.png', 'rb')
    		f.seek(8 +8+13+4)
    		chunk = []
    		while 1:
        		n = struct.unpack('>L', f.read(4))[0]
        		if n==0: break  # 'IEND' chunk
        		f.read(4) # 'IDAT'
        		chunk.append(f.read(n))
        		f.read(4)   # CRC
    		f.close()
    		return zlib.decompress(''.join(chunk))  # '\x00' prefix each line

	def run(self): 
		while self.running:
		    im = camera.take_photo('RGB', (160,120))
		    im.rectangle([(10,10),(40,40)], 0xff0000)   # red outline
		    im.rectangle([(120,10),(150,40)], 0xff0000) # no code for this square
		    # check hot spot whether active
  		    box = Image.new((30,30), 'L')  # gray scale
   		    box.blit(im, (10,10,40,40))
		    data = self.getdata(box, 8)
    		    # check difference for motion
    		    pixdiff = 0
    		    for i in range(len(data)):
                      	if abs(ord(data[i])-ord(self.last[i])) > 15:  # pix threshold 15/256
            			pixdiff += 1
            			if pixdiff > 90:    # img threshold 90/900
                			im.rectangle([(10,10),(40,40)], fill=0xff0000)  # fill
					self.vote +=1
					print "motion: %d/%d" %(self.vote,self.threshold)
					if self.vote >= self.threshold:
						self.callback()	
						self.vote=0
                			break           # motion detected
    	            self.last = data
                    app.body.blit(im, (0,0), (8,12))   # show camera
		    try:
                    	e32.reset_inactivity_time()
		    except:
			pass

if __name__ == '__main__':
	m=Motion(threshold=1)
	m.run()
