#!/usr/bin/python
#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------

# gps.py
# (C) 2006 M. Andreoli
# some simpel GPS routine 


__all__ = [ 'gps', 'gpstrack',
          ]

import os, sys, string
from misc import * 
from unix import man
from nokia import say 

import socket,select
import ext 


if sys.platform.find("symbian")>=0:
	pf="S60"
elif sys.platform.find("linux")>=0:
	import bluetooth
	pf="bluez"

class GPS:
	def __init__(self,address,channel=1):
		self.reset()
		self.delay=4
		self.dumpfile="dump.nmea"
		self.connect(address,channel)
		try:
			self.f=file(self.dumpfile,"w+")
		except:
			log("problem opening dumpfile %s" % self.dumpfile)
	def reset(self):
		self.gpgsv=False
		self.gprmc=False
	def acquired(self):
		return self.gpgsv & self.gprmc	

	def connect(self,address='',channel='1'):
		channel=int(channel)

		if pf=="S60":
			self.sock = socket.socket(socket.AF_BT,socket.SOCK_STREAM)
		elif pf=="bluez" :
                	self.sock=bluetooth.BluetoothSocket( bluetooth.RFCOMM )

		if address=='' and  pf=="bluez":
			print "sorry: discovery unsupported"
			print "please, specify addr and channel"
			self.sock=0
			self.connected=False
			return
		if address=='':
			print "please, look to the phone device ..."
			address,services = socket.bt_discover()
			print "Discovered: %s, %s"%(address, services)
			channel=services.values()[0]
			target = (address, channel)

		target = (address, channel)
		print "Connecting to " + str(target)
		self.connected=True
		try:
			self.sock.connect(target)
			print "ok!"
		except:
			self.connected=False
		
	
	def close(self):
		self.sock.close()
		self.f.close()
	def getSocket(self):
		return self.sock

	def read(self):
		if not self.connected:
			print "non gps connection"
			return None
		data=''
		while select.select([self.sock],[],[],0.1)[0]:
			line=self.sock.recv(8192)
			data+=line
		return data

	def acquire(self):
		self.reset()

		while not self.acquired():
			data=self.read()
			self.parse_packet(data)

	def stop(self):
		self.ta.cancel()
		self.close()
		print "track finish"
		say("track finito")			

	def track(self, duration=None):

		if duration!=None:
			self.ts=ext.Timer(duration,self.stop)
			self.ts.start()

		data=self.read()
		print "data(%s)" %data
		if len(data)==0:
			self.ta=ext.Timer(1,self.track)
			self.ta.start()
		else:		
			self.ta=ext.Timer(self.delay,self.track)
			self.ta.start()
			self.f.write(data)

	# parse socket data 
	def parse_packet(self,data):		
		#print "data(%s)" %data
		fields=data.split('$')	
		for f in fields:
			field=f.strip()
			if len(field)==0:
				print "waiting ..."
			else:	
				self.parse(field)

	# parse NMEA data 
	def parse(self,data):		

		print "nmea(%s)" %data
		nmea = data.split(",")

		self.sat="?"
		if nmea[0]=="GPGSV":
			print "parsing the $GPGSV data ..."	
			self.sat=nmea[3]
			self.gpgsv=True

		if (nmea[0]=="GPRMC"):
			self.gprmc=True
			print "parsing the $GPRMC data ..."	
		
			# Parse the GPS packet
			self.GPRMC = nmea[0]
			self.utc = nmea[1]
			self.status = nmea[2]
			self.lat = nmea[3]
			self.latns = nmea[4]
			self.lon = nmea[5]
			self.lonew = nmea[6]
			self.knots = nmea[7]
			self.course = nmea[8]
			self.date = nmea[9]
			self.xx1 = nmea[10]
			self.xx2 = nmea[11]
		

def gpstrack(duration='20'):
	address="00:0B:0D:6C:D4:7D"; channel="1"
	g = GPS(address,channel)

        if not g.connected:
                man('gps')
                return

        g.track(int(duration))
        return

		
def gps(address="",channel="1"):
        """
        gps - search the GPS device and print gps data 
        Usage:
              	gps 
		gps address channel

	Example:

		gps 00:0B:0D:6C:D4:7D 1

	Using Bluez, you must specify addr and channel because the
	device discovery is non implemented yet.

        """

	g = GPS(address,channel)

        if not g.connected:
                man('gps')
                return

	g.acquire()

	print "======== Data ======="
	#print "sat=%s" %g.sat
	print "latitude=%s,%c" %(g.lat,g.latns)
	print "longitude=%s,%c" %(g.lon,g.lonew)
	print "UTC=%s" %g.utc
	print "date=%s" %g.date

	g.close()

