#!/usr/bin/env python

#----------------------------------------
# pyfs: Python Interactive UNIX shell
#----------------------------------------

# client.py (C) 2006 M. Andreoli 
# Usage: client.py [host port]
# Es:
#	client.py 00:16:4E:D3:75:55 5 ( mode=BT)
#	client.py 192.168.1.20 81 ( mode=TCP)

import stream
import sys,os
import time
import traceback
from misc import *

verbose=0
prompt='>> '

def usage():
	prg=os.path.basename(sys.argv[0])
	print "\n%s: from pyfs, by M.Andreoli" % prg
	print "Usage:"
	print "\t%s host [port]" %prg
	print "\t%s -h" %(prg)
	print "Examples:" 
	print "\t%s 00:1C:9A:EE:C6:F3 5 (BT mode)" %(prg)
	print "\t%s localhost 81 (TCP mode)" %(prg)
	print "Personal use only:" 
	print "\t%s -n70 or -n95 (my phones)" %(prg)
	sys.exit(1)

#----------
# init
#----------

if len(sys.argv) == 3:
	host=sys.argv[1]
	port=int(sys.argv[2])
elif len(sys.argv) == 2:
	host=sys.argv[1]
	port=None
	if host=="-n95": 
		host="00:1C:9A:EE:C6:F3"
		port=5
	if host=="-n70": 
		host="00:16:4E:D3:75:55"
		port=5
else:
	usage()

if host.find("-h")>=0:
	usage()

if host.find(':')>=0:
	mode='BT'
else:
	mode='TCP'


#--------------------------
# the client main routine
#--------------------------

def getprompt(data):
	global prompt
	global conn

	if data==prompt:
		return True
	
	#print "getprompt[%s]" % data

	a=data.split('|')
        if a[0]=='EVAL':
		# syntax: EVAL|cmd
		# evaluate 'cmd' with python interpreter, returning result
		#print "client: evaluating [%s]" % a[1]
		cmd=compile(a[1],'<string>','single')
		save=sys.stdout
		sys.stdout=conn
		eval(cmd,globals())
		sys.stdout=save
        elif a[0]=='SYSTEM':
		# syntax: SYSTEM|cmd
		print "executing [%s]" % a[1]
		os.system(a[1])
        elif a[0]=='STOR':
		# syntax: STOR|filename|directory
		#print "debug: %s " %data
		filename=a[1]; directory=a[2];
		dst=os.path.join(directory,filename)
		conn.recfile(dst)
        elif a[0]=='RETR':
		# syntax: RETR|filename
		filename=a[1]
		conn.sendfile(filename)
        elif a[0]=='PROMPT':
                prompt=a[1]
                #print "set prompt to [%s]\n" % prompt
        elif a[0]=='PING':
                print "client: ping received [%s]" % a[1]
                conn.write("PONG %s" % a[1])
        elif a[0]=='KEYB':
		n=int(a[1])
                k=sys.stdin.read(n)[0:n]
                sys.stdin.read(1) # leggi \n
                conn.write(k)
        else:
                sys.stdout.write("%s"%data)

	return False
	
def main():
	global prompt
	#print "prompt=%s" % prompt
	finish=False

	try:
		conn.connect(host=host,port=port)
	except:
		trace("client.py: connection impossible")
		return
	try:
		import readline
	except:
		pass


	while not finish: 
		# loop: server output
		#----------------------
		while 1:
			try:
				data=conn.read()
			except:
				break

			# getprompt() is the client-side part

			if getprompt(data) : break

		# loop: user input
		#------------------------------
		sys.stdout.flush()
		try:
				line=raw_input(prompt)
		except KeyboardInterrupt:
			print "control-C called"
			break
		except:
			print "server dead? quit"
			break
		if line=='exit':
			conn.write(line)
			break
		if len(line)==0:
			line='\n'	# this a null shell command 
		conn.write(line)

	# try to shutdown the shell, if possible
	try:
		conn.write('exit')
	except:
		pass

#-----------
# MAIN 
#-----------

conn=stream.Stream(mode,verbose)

try:
	main()
	conn.close()
finally:
	conn.close()
# End
