#!/usr/bin/env python

#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------
# shell.py
# (C) 2006 M. Andreoli
 

# shell.py is a wrapper around unix.py, with (some) metacommand.
# You can run a local instance executing "shell.py" at the prompt.


# NB: this class incorporate a clean __builtins__
# 

import string

class SelfClearingNamespace:
    def __init__(self):
        self.namespace={'__builtins__': __builtins__,
                        '__name__': '__main__',
			'ENV':{}
			}
    def __del__(self):
        # Here's a subtle case. The default namespace is deleted at interpreter exit,
        # but these namespaces aren't since all but the most trivial scripts create
        # reference cycles between the functions defined in the script and the namespace of
        # the script. To avoid this we explicitly clear the old namespace to break these
        # reference cycles.
        self.namespace.clear()
    def addvar(self,var,value):
	self.namespace[var]=value
    def addenv(self,var,value):
	(self.namespace['ENV'])[var]=value
    def get(self):
	return self.namespace

# name space for external python scripts
namespace = SelfClearingNamespace()

import sys,os,re
import traceback
import time
from misc import trace
from version import VERSION
console_prompt=">> "
shell_prompt="sh> "

"""
define HOME
it is import in the modules with:
	from shell import HOME
"""

if os.path.exists('E:\\System\\apps\\pyfs'):
    # pyfs home
    HOME = 'E:\\System\\apps\\pyfs'
elif os.path.exists('/home/michele/devel/pyfs'):
    # my LINUX computer
    HOME = '/home/michele/devel/pyfs'
elif os.path.exists('C:\\Python'):
    HOME = 'C:\\Python'
elif os.path.exists('E:\\Python'):
    HOME = 'E:\\Python'
elif os.path.exists('C:\\'):
    HOME = 'C:\\'
else:
    #raise 'cannot find python home directory'
    pass

try:
        os.chdir(HOME)
	namespace.addvar('HOME',HOME)
except:
	trace("chdir(HOME) exception")

class Shell:
    def __init__(self,verbose=0,prompt=shell_prompt,timing=0):
	self.status={0:'off',1:'on'}
	self.timing=timing
	self.verbose=verbose
	self.prompt=prompt
	# externals modules
	self.modules={}
	# internal commands are cmd_*
	
        self.commands={
		       'nop': self.cmd_nop,
                       'quit': self.cmd_quit,
                       'eval': self.cmd_eval,
                       'exe': self.cmd_exe,
                       'enter': self.cmd_enter,
                       'verbose': self.cmd_verbose,
                       'timing': self.cmd_timing,
                       'shutdown': self.cmd_shutdown}
	# external commands
	for m in ['unix','nokia','gps','extras']:
		try:
			self.install_module(m)
    		except:
			self.log("exception installing module %s"% m)
			trace("install_module")
    #-------------
    # misc 
    #-------------

    def myself(self):
	    return self

    def set_prompt(self,s):
	self.prompt=s
	# send the PROMPT directive to the client
	sys.stdout.write("PROMPT|%s|\n" % self.prompt)

    def remove_module(self,name):
    	from string import split, join

        for module in sys.modules.keys():
            s = split(module, ".")
            if s[0] == name:
                s = join(s,".")
                del sys.modules[s]

    def install_module(self,modname):
	module=__import__(modname)
	for name in module.__all__:
		cmd=module.__dict__.get(name)
		if cmd: 
			self.commands[name]=cmd
			#globals()[name]=cmd
	# initialize the module, passing the "self" class instance
	cmd=module.__dict__.get("__init__")
	if cmd: cmd(self)
	self.modules[modname]=module
	
    def debug(self,msg):
	if self.verbose:
        	sys.stderr.write("SHELL: "+msg+"\n")
    def log(self,msg):
    	sys.stderr.write("%s\n" %msg)

    
    #--------------
    # public misc commands 
    #-------------

    
    def cmd_nop(self,*args):
	pass
    def cmd_verbose(self,*args):
	self.verbose=not self.verbose
    	print "verbose %s"%self.status[self.verbose]	
    def cmd_timing(self,*args):
	self.timing=not self.timing
    	print "timing %s"%self.status[self.timing]	
    def cmd_exit(self,*args):
	sys.stderr.write("shell called exit\n")
	self.debug("exiting")

	for module in ['unix','nokia','gps','extras']:
	        self.remove_module(module)
        self.finished=True
    def cmd_enter(self,*args):
	print "problems??"
    def cmd_quit(self,*args):
	print "Please, use 'exit'"
    def cmd_shutdown(self,*args):
	self.debug("to do")
    def cmd_put2(self,*args):
	filename=args[0]
        content=sys.stdin.readline()
        f=open(filename,'wb')
        f.write(content)
        f.close()
        print "Wrote %d bytes to %s."%(len(content),filename)
									    
    #--------------
    # public IO commands 
    #-------------
    
    def cmd_eval(self,*args):
	#sys.stderr.write("evaluate: %s\n" % repr(args))
	line=string.join(args)
	cmd=compile(line,'<string>','single')
        try:
		#exec cmd
		eval(cmd,globals())
        except:
            	import traceback
		error_type, error, traceback = sys.exc_info()
		try:
			print error
   		except:
			pass 

    def cmd_exe(self,*args):
	file=args[0]
        try:
		#print "namespace=%s" % namespace.get()
        	execfile(file,namespace.get())
        	#execfile(file,globals())
        	#execfile(file)
        except:
            	import traceback
		error_type, error, traceback = sys.exc_info()
            	#traceback.print_exc()
		try:
			print error
   		except:
			pass 
    #--------------
    # special commands 
    #-------------


    def run(self,connection=None,program=None):
        self.finished=False

	print "UNIX-LIKE Shell v0.%d, %s" %(VERSION,sys.platform)
	print "External modules: %s" % repr(self.modules.keys())
	print "Help: write 'man', or 'man command'"
	print "Quit with 'exit'"
	print "\n"
	self.set_prompt(shell_prompt)
        while not self.finished:
		self.debug('waiting for input ...')
		sys.stdout.flush()
		line=''
		line=raw_input(self.prompt)
		line.strip()
		self.interpret(line)


    # execute a single line as shell commands
    # order of check:
    #	1) shell commands
    #	2) bin/line 
    #	3) bin/line.py
    #   4) line
    #   5) direct to python interpreter

	
    def interpret(self,line):

	list=line.split()

	if len(list)==0:
		cmd="enter"; args=[]
	else:
		cmd=list[0].strip(); args=list[1:]
	
       	cmdfunc=self.commands.get(cmd,self.cmd_nop)

	if cmdfunc==self.cmd_nop:
		cmdfunc=self.cmd_eval
		cmd="cmd_eval"
		#args=[line]
		args=list
		if re.search(".*\.py$", line):
			cmd="cmd_exe"
			cmdfunc=self.cmd_exe

	self.debug("calling cmd=[%s], args=%s" %(cmd, repr(args)) )

	try:
		cmdfunc(*args)
	except:
		#trace("error executing %s" %cmd )
            	import traceback
		error_type, error, traceback = sys.exc_info()
		print error
			
	
def main():
	try:
		import readline
	except:
		try:
			sys.exc_clear()
		except:
			pass

	s=Shell(verbose=verbose)
	try:
		s.run()
	except:
		traceback.print_exc()
		s.cmd_exit()
		del s	

#--------------------------
# MAIN
#--------------------------

if __name__ == '__main__':
	verbose=0
	main()
