#----------------------------------------
# pyfs: simple fileserver/shell in Python
#----------------------------------------

# misc.py
# (C) 2006 M. Andreoli
# miscellanea 

from __future__ import generators	# for v 2.2

BLOCKSIZE=5120*4

import os,sys,traceback
from ext import glob


# check remote system type

def remote_platform(*args):
	sys.stdout.write("EVAL|import sys; sys.platform")
	platform=sys.stdin.read()	
	nl=sys.stdin.read()
	return platform[1:-1]

def trace( msg = '',file=sys.stdout ):
    import sys,traceback
    if msg=='':
	msg="trace"
    error_type, error, traceback = sys.exc_info()
    if error==None:
	error=""

    out="TRACE: %s: %s\n" % (msg, error)
    #print out 
    file.write(out)

# os.walk (rustic) implementation

def my_walk(top, topdown=True, onerror=None):
    names = os.listdir(top)

    dirs, nondirs = [], []
    for name in names:
        if os.path.isdir(os.path.join(top, name)):
            dirs.append(name)
        else:
            nondirs.append(name)

    if topdown:
        yield top, dirs, nondirs
    for name in dirs:
        path = os.path.join(top, name)
        if not os.path.islink(path):
            for x in my_walk(path, topdown, onerror):
                yield x
    if not topdown:
        yield top, dirs, nondirs

# win32 glob() is different from linux ...

def myglob(str):
	if str[0]=="-":		# unix option
		e=[]; e.append(str)
		return e 

	e=glob(norm(str))

	if len(e)==0:	# the file not exists
		e.append(norm(str))
                return e
	return e

# norm() add CWD to path, and other 

def norm(x):
	cwd=os.getcwd()
	xx=os.path.normpath( os.path.join(cwd,x))
	return xx


# abs path -> relative path

def relative(path):
	cwd=os.getcwd()+os.path.sep
	return path.replace(cwd,'')

# parse tuple/array arguments a-la-UNIX, returning array
		
def parse(a):
	r=[]
	for x in a:
		r.extend( myglob(x) )
	return r


# parse tuple/array arguments a-la-UNIX, returning python tuples 

def tparse(a):
        r=()
        for x in a:
		for y in myglob(x):
			r=r+(y,)
        return r

# ask the client for a keyboard input

def input(prompt='',n=1):
	sys.stdin.flush()
	sys.stdout.write(prompt)
	sys.stdout.write("KEYB|%d"%n)
        return sys.stdin.read()[0:n]

