#!/usr/bin/python

# ext.py
# python class wrappers

#---------------------------
# timers for S60 e linux
#---------------------------
import time,sys,os
import fnmatch
import re


__all__=['glob','Timer']

try:
	import e32
	s60=True
except:
	import threading
	s60=False

class Timer:
	def __init__(self,i,cb=None,verbose=False):
		self.i=i
		self.cb=cb
		self.verbose=verbose
		self.logger=lambda x: sys.stderr.write(x+"\n")
		if cb==None:
			self.cb=self.dummy_cb 
		if s60:
			self.t=e32.Ao_timer()
		else:
			self.t=threading.Timer(i,self.cb)
	def value(self):
		return self.i
	def log(self,msg):
		if self.verbose:
			self.logger(msg)	
	def cancel(self):
		self.log("timer (%d s) cancelled: %s" % (self.i,time.ctime()) )
		self.t.cancel()
	def start(self):
		self.log("timer (%d s) start %s" % (self.i,time.ctime()) )
		if s60:
			self.t.after(self.i,self.cb)
		else:
			self.t.start()
	def dummy_cb(self):
		self.log("timer (%d s) end %s" % (self.i,time.ctime()) )


def glob(pathname):
    """Return a list of paths matching a pathname pattern.

    The pattern may contain simple shell-style wildcards a la fnmatch.

    """
    if not has_magic(pathname):
        #if os.path.lexists(pathname):
        if os.path.exists(pathname):
            return [pathname]
        else:
            return []
    dirname, basename = os.path.split(pathname)
    if not dirname:
        #return glob1(os.curdir, basename)
        return glob1('.', basename)
    elif has_magic(dirname):
        list = glob(dirname)
    else:
        list = [dirname]
    if not has_magic(basename):
        result = []
        for dirname in list:
            if basename or os.path.isdir(dirname):
                name = os.path.join(dirname, basename)
                if os.path.lexists(name):
                    result.append(name)
    else:
        result = []
        for dirname in list:
            sublist = glob1(dirname, basename)
            for name in sublist:
                result.append(os.path.join(dirname, name))
    return result

def glob1(dirname, pattern):
    #if not dirname: dirname = os.curdir
    if not dirname: dirname = '.'
    try:
        names = os.listdir(dirname)
    except os.error:
        return []
    if pattern[0]!='.':
        names=filter(lambda x: x[0]!='.',names)
    return fnmatch.filter(names,pattern)





magic_check = re.compile('[*?[]')

def has_magic(s):
    return magic_check.search(s) is not None



################
# main
################



if __name__ == "__main__":
	t1=Timer(4,verbose=True)
	t1.start()


