#!/usr/bin/python

# pyed17.py (see About)
# with modification from M.Andreoli (2007)


from __future__ import division
from appuifw import *
from e32 import *
from key_codes import *
import os
import sys
from ext import glob # from 2.2 not included with Amaretto !
import fnmatch
#from dir_iter import *
import codecs
import re

r_endword = re.compile(r'[A-Za-z0-9_]+$')
r_startword = re.compile(r'^[A-Za-z0-9_]+')

class my_app:
   def getword(self, input, pos):
        """From Sean B. Palmer, http://inamidst.com/sbp/"""
        try: eword = r_endword.search(input[:pos]).group(0)
        except AttributeError: eword = '' 
        try: sword = r_startword.match(input[pos:]).group(0)
        except AttributeError: sword = ''
        if not (eword or sword): return None
        return eword + sword


   def single_text_query(self,string,def1):
       a=query(string, 'text',def1)
       if a is None:
           pass
       else:
           return a

   def single_nb_query(self,string,def1):
       a=query(string, 'number',def1)
       if a is None:
           pass
       else:
           return a

   def yesno_query(self,string):
       a=query(string,'query')
       if a is None:
           pass
       else:
           return a



   def display(self,t):
       if t is None:
           pass
       else:
           note(u""+ "\n" + t, 'info')

   def displayabout(self,t):
       if t is None:
           pass
       else:
           note(u""+  t, 'info')
           
           
   def displaytitle(self,legend,t):
       if t is None:
           pass
       else:
           note(unicode(legend) + "\n" + t, 'info')
           
   def displaytech(self,legend,t):
       if t is None:
           pass
       else:
           note(unicode(legend) + t, 'info')        
   
   def displaysettings(self,setting1,t1,setting2,t2):
       if t1 is None or t2 is None:
           pass
       else:
           note(unicode(setting1) + "\n" + t1 + "\n" + unicode(setting2) + "\n" + t2, 'info')
   
           
   def displayconf(self,t):
       if t is None:
           pass
       else:
           note(u'' + t, 'conf')

   def __init__(self):
       self.script_lock = Ao_lock()      #needed for "active objects" (threads)
       self.filename = u'pyed17.py'
       self.path =  u'e:\\system\\apps\\pyfs\\'
       self.pathf = self.path + self.filename
       self.deftab = 4*u' '  
       self.nbtab = 4
       self.i_display = 2
       self.file_len = 0
       self.curlin = 0
       self.curcol = 0
       self.curpos = 0
       self.curdir = 0
       self.curslin = 0
       self.app_name= u'pyED\n'
       self.pyed_ver= u'v alpha 16'
       self.mode = 0
       self.lines = []
       self.run_by = u''
       self.run_by_mode = u''
       self.sz = 10
       self.char = u'|'

   def run(self, filename=None):
       self.filename=filename

       oldBody = app.body
       oldExit = app.exit_key_handler
       oldFocus =app.focus
       oldMenu = app.menu
       oldScreen = app.screen
       oldTitle = app.title


       app.title = self.app_name+self.pyed_ver
       app.body = Text()
       app.menu = [(u'File ...', self.popfile),(u'Tools ...',self.poptools),(u'Setting ...',self.popset) ,(u'About pyED !',self.about),(u'Quit', self.quit)]
       self.get_run_by()
       self.set_mode_normal()
       app.exit_key_handler = self.fquit
       if filename != None:
		self.open()
       else:
		self.open_sel()
       self.script_lock.wait()
       app.body = oldBody
       app.exit_key_handler = oldExit
       app.focus = oldFocus
       app.menu = oldMenu
       app.screen = oldScreen
       app.title = oldTitle


 
   def fullname(self):
       self.displaytitle(u'App Name',app.full_name())
   
   def set_exit_if_standalone(self):
       if self.run_by_mode == u'Python Installer':
          app.set_exit()
   
   def get_run_by(self):
       self.run_by = app.full_name()
       if self.run_by[-10:] == u'Python.app':
        self.run_by_mode = u'Python Interpreter'
       elif self.run_by[-10:] == u'appmgr.app':
        self.run_by_mode = u'Python Installer'
       else: 
        self.run_by_mode = u'Unknown ...'
        
   def quit(self):
       app.exit_key_handler = None
       self.script_lock.signal()
       self.set_exit_if_standalone()

   def fquit(self):
       self.popnav()

   def default_cancel(self):
       app.body.bind(EKeyBackspace,None)
       self.displayconf(u'Enable Cancel')

   def redefined_cancel(self):
       app.body.bind(EKeyBackspace,new_cancel)
       self.displayconf(u'Disable Cancel')

   def c_toggle_mode(self):
       if self.mode == 0:
        self.redefined_cancel() 
        self.mode = 1
       elif self.mode == 1:
        self.default_cancel() 
        self.mode = 0
       else:
        self.displayconf(u'Exception Error !')

   def new_cancel(self):
       pass
       
   def set_mode_nav(self):
       pass

   def set_mode_search(self):
       pass

   def set_mode_edit(self):
       pass

   def set_mode_normal(self):
       app.body.bind(EKeyYes,self.popmodes)
       app.body.bind(EKeyDevice3,self.popedit)
       app.body.bind(EKeySpace,self.cbk_joy)
       app.body.bind(EKeyEnter,self.cbk_enter)
       app.body.bind(EKeyDownArrow,self.cbk_titled)
       app.body.bind(EKeyLeftArrow,self.cbk_titlel)
       app.body.bind(EKeyRightArrow,self.cbk_titler)
       app.body.bind(EKeyUpArrow,self.cbk_titleu)
       # self.default_cancel()
      
   def cbk_joy(self):
       app.title = u'joy'

   def cbk_enter(self):
       app.title = u'enter'

   def cbk_a(self):
       self.display_title_pos()


   def cbk_titler(self):
     self.curdir = -1  
     self.cbk_title()
 
   def cbk_titled(self):
     self.curdir = 3  
     self.cbk_title()

   def cbk_titleu(self):
     self.curdir = 4  
     self.cbk_title()

   def cbk_titlel(self):
     self.curdir = 1  
     self.cbk_title()

   def cbk_title(self):
       if self.i_display == 2:
           self.display_title_file()
       elif self.i_display == 3:
           self.display_title_pos()
       elif self.i_display == 4:
           self.display_title_prg()
       elif self.i_display == 5:
           self.display_title_lines()
       elif self.i_display == 6:
           self.display_title_graph()

   
   def tobegin(self):
       app.body.set_pos(0)

   def tomid(self):
       app.body.set_pos(app.body.len()/2)
           
   def toend(self):
       app.body.set_pos(app.body.len())

   def setsz(self):
       n = self.single_nb_query(u'Enter size : ',self.sz)
       self.sz = n

   def setchar(self):
       n = self.single_text_query(u'Enter size : ',self.char)
       self.char = n

   def tocursor(self):
       n = self.single_nb_query(u'Enter pos : ',0)
       app.body.set_pos(n)

   def topc(self):
       n = self.single_nb_query(u'Enter % : ',0)
       app.body.set_pos((app.body.len()/100)*n)

   def cursorback(self,b):
       app.body.set_pos(app.body.get_pos()-b)

   def cursorf(self,b):
       self.cursorback(-b)

   def toline(self):
       n = self.single_nb_query(u'Enter line : ',1)
       self.retposfromlin(n)
       app.body.set_pos(self.retposfromlin(n))

   def popnav(self):
       list1 = [u'File ...',u'Screen ...',u'Code ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.popgotofile()
          elif ind1 == 1:
            self.poptoscreen()
          elif ind1 == 2:
            self.poptocode()
       else:
          self.displayconf(u'Cancel')
       
   def popgotofile(self):
       list1 = [u'% ...',u'Begin of File',u'Middle of File',u'End of File',u'Line ...',u'Cursor ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.topc()
          elif ind1 == 1:
            self.tobegin()
          elif ind1 == 2:
            self.tomid()
          elif ind1 == 3:
            self.toend()
          elif ind1 == 4:
            self.toline()
          elif ind1 == 5:
            self.tocursor()
       else:
          self.displayconf(u'Cancel')

   def poptocode(self):
       pass

   def tobol(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
       poseol = app.body.get_pos()-col+1
       self.displayconf(unicode(poseol))
       app.body.set_pos(poseol)

          
   def toeol(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
       self.displayconf(unicode(lin))
       self.displayconf(unicode(col))
       self.displayconf(self.lines[lin-1])
       poseol = app.body.get_pos()-col+len(self.lines[lin-1])+1
       self.displayconf(unicode(poseol))
       app.body.set_pos(poseol)

   def pageup(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
       lin = lin - 7
       pos = self.retposfromlin(lin) 
       self.displayconf(unicode(pos))
       # app.body.set_pos(pos)

   def pagedown(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
       lin = lin + 7 # attention 1 logical line is different from screen line !
       pos = self.retposfromlin(lin) 
       app.body.set_pos(pos)

   def home(self):
       app.body.set_pos(0)
          
   def poptoscreen(self):
       list1 = [u'Begin of line',u'End of line',u'Page Up',u'Page Down',u'Home'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.tobol()
          elif ind1 == 1:
            self.toeol()
          elif ind1 == 2:
            self.pageup()
          elif ind1 == 3:
            self.pagedown()
          elif ind1 == 4:
            self.home()
       else:
          self.displayconf(u'Cancel')

   def popfile(self):
       list1 = [u'Open current',u'Open Sel ...',u'Save',u'Save As ...',u'New ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.open_cur()
          elif ind1 == 1:
            self.open_sel()
          elif ind1 == 2:
            self.save()
          elif ind1 == 3:
            self.saveas()
          elif ind1 == 4:
            self.new()
       else:
          self.displayconf(u'Cancel')

   def popedit(self):
       list1 = [u'Block Indent ...',u'Symbol 1 ...',u'Symbol 2 ...',u'Python Word ...',u'Python Struct ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.popindent()
          elif ind1 == 1:
            self.popsymbol1()
          elif ind1 == 2:
            self.popsymbol2()
          elif ind1 == 3:
            self.poppyw()
          elif ind1 == 4:
            self.poppys()
       else:
          self.displayconf(u'Cancel')

   def popmodes(self):
       list1 = [u'Edit ...',u'Browse ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.displayconf(u'Edit')
          elif ind1 == 1:
            self.displayconf(u'Browse')
       else:
          self.displayconf(u'Cancel')

   def popsymbol1(self):
       list1 = [u'Tab',u'()',u'[]',u'{}',u'==',u'\\\\'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.instab()
          elif ind1 == 1:
            self.inspars()
          elif ind1 == 2:
            self.insbra()
          elif ind1 == 3:
            self.insacol()
          elif ind1 == 4:
            self.insequal()
          elif ind1 == 5:
            self.insbslash()
       else:
          self.displayconf(u'Cancel')

   def popindent(self):
       list1 = [u'Same',u'Next',u'Up'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.indentsame()
          elif ind1 == 1:
            self.indentnext()
          elif ind1 == 2:
            self.indentup()
       else:
          self.displayconf(u'Cancel')

   def popsymbol2(self):
       list1 = [u'Doc',u'#',u'_',u'Multi tabs',u'Char Repeat'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.insdoc()
          elif ind1 == 1:
            self.inscomment()
          elif ind1 == 2:
            self.insunderscore()
          elif ind1 == 3:
            self.insmultitab()
          elif ind1 == 4:
            self.inscharep()
       else:
          self.displayconf(u'Cancel')

   def indentsame(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
#        self.displayconf(unicode(lin)+u'|'+unicode(col))
       posbol = app.body.get_pos()-col+1
       pcol = 0
       while self.lines[lin-1][pcol] == u' ':
          pcol = pcol + 1
       poseol = app.body.get_pos()-col+len(self.lines[lin-1])+1
       app.body.set_pos(poseol)
       app.body.add(u'\n'+pcol*u' ')
#        self.displayconf(unicode(pcol)+u'spaces')

   def retcurindent(self):
       lin,col = self.retlincolfrompos(app.body.get_pos())
       posbol = app.body.get_pos()-col+1
       pcol = 0
       while self.lines[lin-1][pcol] == u' ':
          pcol = pcol + 1
       poseol = app.body.get_pos()-col+len(self.lines[lin-1])+1
       # self.displayconf(unicode(pcol)+u'spaces')
       return pcol*u' ' 

   def indentnext(self):
       self.indentsame()
       app.body.add(self.deftab)


   def indentup(self):
       pass

   def instab(self):
       app.body.add(self.deftab)

   def insenter(self):
       app.body.add(u'\n')

   def inspars(self):
       app.body.add(u'()')
       self.cursorback(1)

   def insbra(self):
       app.body.add(u'[]')
       self.cursorback(1)

   def insacol(self):
       app.body.add(u'{}')
       self.cursorback(1)

   def insequal(self):
       app.body.add(u'==')

   def insbslash(self):
       app.body.add(u'\\\\')

   def insdoc(self):
       app.body.add(u'"""\n"""')
       self.cursorback(3)

   def inscomment(self):
       app.body.add(u'# ')

   def insunderscore(self):
       app.body.add(u'_')

   def insmultitab(self):
       n = self.single_nb_query(u'Repeat tab : ',2)
       chars = n * self.deftab 
       app.body.add(chars)

   def inscharep(self):
       char = self.single_text_query(u'Enter char : ',self.deftab)
       n = self.single_nb_query(u'Repeat '+char+u' :',2)
       chars = n * char 
       app.body.add(chars)

   def poppyw(self):
       list1 = [u'String ...',u'Unicode() ...',u'self ...',u'call def self ...',u'Def: ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.insstr()
          elif ind1 == 1:
            self.insunicode()
          elif ind1 == 2:
            self.insself()
          elif ind1 == 3:
            self.insdefself()
          elif ind1 == 4:
            self.insprint()
       else:
          self.displayconf(u'Cancel')

   def poppys(self):
       list1 = [u'Class: ...',u'Def: ...',u'If: ...',u'While: ...',u'For: ...',u'nDef: ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.insclass()
          elif ind1 == 1:
            self.insdef()
          elif ind1 == 2:
            self.insif()
          elif ind1 == 3:
            self.inswhile()
          elif ind1 == 4:
            self.insfor()
          elif ind1 == 5:
            self.insnewdef()
       else:
          self.displayconf(u'Cancel')

   def insprint(self):
       app.body.add(u'print ')

   def insself(self):
       app.body.add(u'self')

   def insdefself(self):
       defn = self.single_text_query(u'Enter def name : ',u'')
       self.insself()
       app.body.add(u'.')
       app.body.add(defn)
       self.inspars()
       self.cursorf(1)
       self.insenter()


   def insstr(self):
       app.body.add(u'u'+"''")
       self.cursorback(1)

   def insunicode(self):
       app.body.add(u'unicode()')
       self.cursorback(1)

   def insclass(self):
       cln = self.single_text_query(u'Enter class name : ',u'')
       app.body.add(u'?')

   def insnewdef(self):
       defn = self.single_text_query(u'Enter def name : ',u'')
       curtab = self.retcurindent()
       l = u'\n\n'+curtab+u'def '+defn+u'(self):\n'+curtab+self.deftab+u'pass\n'+curtab+self.deftab+u'\n\n'
       app.body.add(l)

   def insdef(self):
       defn = self.single_text_query(u'Enter def name : ',u'')
       self.insenter()
       self.insenter()
       self.instab()
       app.body.add(u'def '+ defn + u'(self):')
       self.insenter()
       self.instab()
       self.instab()
       app.body.add(u'pass')
       self.insenter()

   def insif(self):
       ift = self.single_text_query(u'Enter if test : ',u'')
       self.instab()
       app.body.add(u'if ')
       app.body.add(ift+u':')
       self.insenter()
       self.instab()
       self.instab()
       app.body.add(u'pass')
       self.insenter()
       self.instab()
       app.body.add(u'elif :')
       self.insenter()
       self.instab()
       self.instab()
       app.body.add(u'pass')
       self.insenter()
       self.instab()
       app.body.add(u'elif :')
       self.insenter()
       self.instab()
       self.instab()
       app.body.add(u'pass')
       self.insenter()
       self.instab()
       app.body.add(u'else :')
       self.insenter()
       self.instab()
       self.instab()
       app.body.add(u'pass')
       self.insenter()

   def inswhile(self):
       app.body.add(u'?')

   def insfor(self):
       app.body.add("""pass
""")

   def popset(self):
       list1 = [u'Path ...',u'File ...',u'Tab ...',u'Change title ...',u'Graph size ...',u'Graph char ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          #self.displaytitle('You choose ',list1[ind1])
          if ind1 == 0:
            self.setpath()
          elif ind1 == 1:
            self.setfilename()
          elif ind1 == 2:
            self.tab()
          elif ind1 == 3:
            self.poptitle()
          elif ind1 == 4:
            self.setsz()
          elif ind1 == 5:
            self.setchar()
       else:
          self.displayconf(u'Cancel')

   def i_search(self):
       sto = []
       stol = [] 
       curpos = 0
       txt = app.body.get()
       cpos = app.body.get_pos()
       word = self.single_text_query(u'Enter word % : ',self.getword(txt,cpos)
)
       res = txt.find(word,curpos)
       while (res <> -1):
          lin,col = self.retlincolfrompos(res)          
          sto.append(self.lines[lin-1])
          stol.append(lin)
          res = txt.find(word,res+1)
       ind = selection_list(sto)
       app.body.set_pos(self.retposfromlin(stol[ind]))
       self.displayconf(u'goto line '+unicode(stol[ind]))


   def search(self):
       next = 1
       curpos = 0
       txt = app.body.get()
       cpos = app.body.get_pos()
       word = self.single_text_query(u'Enter word % : ',self.getword(txt,cpos)
)
       res = txt.find(word,curpos)
       while (res <> -1) and (next == 1):
          app.body.set_pos(res)
          lin,col = self.retlincolfrompos(res)
          resp = self.yesno_query(word+u'\nFound in pos\n [ '+unicode(lin)+u','+unicode(col)+u' ]\n  Find next ?')
          if resp is None:
            next = 0
          else:  
            app.body.set_pos(res+1)
            res = txt.find(word,res+1)
          
   def replace(self):
       word1 = self.single_text_query(u'Enter word : ',u' ')
       word2 = self.single_text_query(u'Enter word : ',u' ')
       txt = app.body.get().replace(word1,word2)   
       app.body.set(txt)
   
   def poptools(self):
       list1 = [u'Search ...',u'Search i ...',u'Replace ...'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.search()
          elif ind1 == 1:
            self.i_search()
          elif ind1 == 2:
            self.replace()
       else:
          self.displayconf(u'Cancel')
          
   def poptitle(self):
       list1 = [u'File',u'Pos',u'Prg',u'Line and Col',u'Graph'] 
       ind1 = popup_menu(list1)
       if ind1 >= 0:
          if ind1 == 0:
            self.i_display = ind1+ 2
          elif ind1 == 1:
            self.i_display = ind1+ 2
          elif ind1 == 2:
            self.i_display = ind1+ 2
          elif ind1 == 3:
            self.i_display = ind1+ 2
          elif ind1 == 4:
            self.i_display = ind1+ 2
       else:
          self.displayconf(u'Cancel')
 
   def selw(self):
       txt = app.body.get()
       cpos = app.body.get_pos()
       self.displaytitle(u'find word = ',self.getword(txt,cpos)
)
    
   def sel(self):
       lines = app.body.get().splitlines()
       ll = []
       for lin in lines:
         ll.append(unicode(len(lin)))
       self.file_len = len(lines) 
       ind = selection_list(ll)
       app.title = unicode(self.file_len)

   def selfile(self):
       filelist = os.listdir(self.path)
       #self.displaytitle(u'selected len = ',unicode(len(filelist)))
       #self.displaytitle(u'selected file = ',unicode(filelist[0]))
       ll = []
       for file in filelist:
         ll.append(unicode(file))
       ind = selection_list(ll)
       if ind is not None:
        self.displaytitle(u'selected file = ',ll[ind])
        self.filename = ll[ind]  
       
   def getflen(self):
       self.lines = app.body.get().splitlines()
       self.file_len = len(self.lines)
       i = 1 
       acc = 0 
       pos = app.body.get_pos()
       if self.curdir == - 1:
         pos = pos + 1
       elif self.curdir == 1:
         pos = pos - 1 
       while acc <= pos:
         acc = acc + 1 +len(self.lines[i-1])
         i = i + 1 
       self.curlin = i-1
       self.curcol =len(self.lines[i-2])-(acc - pos)+2
       self.curpos = len(self.lines[i-2])

   def retposfromlin(self,l):
       self.lines = app.body.get().splitlines()
       i = 1 
       acc = 0 
       while i < l:
         acc = acc + 1 + len(self.lines[i-1])
         i = i + 1 
       return acc

   def retlincolfrompos(self,p):
       self.lines = app.body.get().splitlines()
       i = 1 
       acc = 0 
       while acc <= p:
         acc = acc + 1 + len(self.lines[i-1])
         i = i + 1 
         # self.displayconf(unicode(i)+u'!'+unicode(acc)+u'!'+unicode(p))

       self.curlin = i-1
       self.curcol = len(self.lines[i-2])-(acc - p)+2
       return self.curlin,self.curcol

   def select2(self):
       this_dir = os.path.split(app.full_name())[0]
       my_script_dir = os.path.join(this_dir,'my')
       script_list = []
       if os.path.exists(my_script_dir):
          script_list = map(lambda x: os.path.join('my',x),filter(is_py, os.listdir(my_script_dir)))
       script_list += filter(is_py, os.listdir(this_dir))
       index = selection_list(map(unicode, script_list))
       if index >= 0:
           self.display("Done.")
       else:
           self.display("Zut.")
		
   def display_title_file(self):
       app.title = unicode(self.filename)
 	 
   def display_title_pos(self):
       pc = unicode(round((app.body.get_pos()/ app.body.len())*100,0)) 
       app.title = u'[ '+str(app.body.get_pos()) + ' , ' + str(app.body.len()) + u' ] '+ pc+u'%'

   def display_title_prg(self):
       app.title = u'pyED alpha 16'

   def display_title_lines(self):
       self.getflen()
       app.title = u'[ '+str(self.curlin) + ' , ' + str(self.curcol) + u' ]' + str(self.curpos)

   def display_title_graph(self):
        pc = round((app.body.get_pos()/ app.body.len())*self.sz,0) 
        app.title = u'[' + int(pc) *self.char + (self.sz-int(pc))*u' '+ ']'
       
   def setpath(self):
       n = self.single_text_query(u'Enter path: ',self.path)        
       if n is None:
           pass
       else:
           self.path = n
           self.pathf=unicode(self.path)+self.filename
           self.displayconf(self.pathf)
        
        
   def setfilename(self):
       n = self.single_text_query(u'Enter filename wildcard : ',self.filename)
       if n is None:
           pass
       else:
           self.filename = n
           self.pathf=unicode(self.path)+self.filename
           self.displayconf(self.pathf)

   def tab(self):
       n = self.single_nb_query(u'Enter tab  lenght : ',4)
       self.deftab = n * u' '
       self.nbtab = n
 
   def about(self):
       self.displayabout(u'  PyED '+u'\nVersion alpha 16'+u'\n'+u'(c) GPL license 2005\n'+self.run_by_mode+u'\nCreated by vddi')
        
   def new(self):
       self.setfilename()
       app.body.clear()

   def open_cur(self):
      self.open()

   def open_sel(self):
       filelist = os.listdir(self.path)
       ll = []
       for file in filelist:
         ll.append(unicode(file))
       ind = selection_list(ll)
       if ind is not None:
        self.filename = ll[ind]  
       self.open()

   def open(self):
       app.body.clear()
       self.pathf = self.path + self.filename
       (encoding,decoding,reader,writer) = codecs.lookup('UTF-8')
       try:
          input = reader(open(self.pathf,'rb'))
          app.body.set(input.read())
          self.tobegin()
          self.displayconf(u"Load "+self.pathf)
       except IOError:
          pass

   def save(self):
       text= app.body.get().encode('utf8').replace("\xE2\x80\xA9","\x0D\x0A")
       open(self.pathf,'wb').write(text)           
       self.displayconf(self.filename+" Saved !")

   def saveas(self):
      self.setfilename()
      self.save()

#
#  main program
#

if __name__ == '__main__':
    my_app().run()
