from appuifw import *
from key_codes import *
import e32, time
 
class StopWatch:
    running = 0
    time_start = None
    elap = 0.0
 
    def __init__(self):
        self.canvas = Canvas(self.update)
        app.body = self.canvas
        self.canvas.bind(EKeySelect, self.toggle)
        self.update()
 
    def update(self, rect=None):
        if self.running:
            self.elap = time.clock() - self.time_start
            e32.ao_sleep(0.05, self.update)
        t = self.elap
        min = int(t / 60)
        sec =  int(t - min*60)
        hsec = int((t - min*60 - sec)*100)
        self.canvas.clear()
        self.canvas.text((20,40), u"%02d:%02d:%02d" % (min,sec,hsec), font='title')
 
    def toggle(self):
        if self.running:
            self.running = 0
            self.elap = time.clock() - self.time_start
        else:
            self.running = 1
            self.time_start = time.clock() - self.elap
            self.update()
 
    def reset(self):
        self.running = 0
        self.elap = 0.0
        self.update()

def quit():
	global lock
	lock.signal()	 

save=app 
sw = StopWatch()
lock = e32.Ao_lock()
app.menu = [(u'Reset', sw.reset), (u'Close', quit)]
app.exit_key_handler = quit 
lock.wait()
app=save
