#-----------------
#Title: breakout
#Author: wicker
#-----------------

import appuifw
from graphics import *
import e32
from key_codes import *
from time import *
import string

class Keyboard(object):
    def __init__(self,onevent=lambda:None):
        self._keyboard_state={}
        self._downs={}
        self._onevent=onevent
    def handle_event(self,event):
        if event['type'] == appuifw.EEventKeyDown:
            xcode=event['scancode']
            if not self.is_down(xcode):
                self._downs[xcode]=self._downs.get(xcode,0)+1
            self._keyboard_state[xcode]=1
        elif event['type'] == appuifw.EEventKeyUp:
            self._keyboard_state[event['scancode']]=0
        self._onevent()
    def is_down(self,scancode):
        return self._keyboard_state.get(scancode,0)
    def pressed(self,scancode):
        if self._downs.get(scancode,0):
            self._downs[scancode]-=1
            return True
        return False
keyboard=Keyboard()

appuifw.app.screen='full'
img=None
def handle_redraw(rect):
    if img:
        canvas.blit(img)
appuifw.app.body=canvas=appuifw.Canvas(
    event_callback=keyboard.handle_event,
    redraw_callback=handle_redraw)
img=Image.new(canvas.size)

def write_score(score,name):
    current_score=read_score().replace('~','').split('\n')
    current_score.append('0'*(4-len(str(score)))+str(score)+' '*8+str(name))
    leng=len(current_score)
    current_score.sort()
    current_score.reverse()

    if leng>10: leng=10
    f=open('c:\\breakscore.txt','w')
    for t in range(0,leng):
        cur=current_score[t]
        if cur!='': f.write(cur+'\n')
    f.close()

def read_score():
    try:
        f=open('c:\\breakscore.txt','r')
        read=f.read()
        f.close()
    except:
        return ''
    return read

name=''
while name=='' or name==None:
    name=appuifw.query(u'Inserisci il tuo nome: ','text')

score=0
life=3
x=70
y=200
ballx=90
bally=170
balldir=[]
xvel=2.4
yvel=2.0
velsp=0
direction=0
n_block=0

rand=0

levelcur=0
level=[]
#level 1
level.append([[40,50],[130,50],[40,60],[50,60],[60,60],[70,60],[80,60],[90,60],[100,60],[110,60],
[120,60],[130,60],[40,70],[50,70],[60,70],[70,70],[80,70],[90,70],[100,70],[110,70],[120,70],[130,70],
[60,80],[70,80],[80,80],[90,80],[100,80],[110,80],[80,90],[90,90]])
#level 2
level.append([[80,70],[90,70],[70,80],[80,80],[90,80],[100,80],[60,90],[70,90],[80,90],[90,90],[100,90],[110,90],
[50,100],[60,100],[70,100],[80,100],[90,100],[100,100],[110,100],[120,100],[60,110],[70,110],[80,110],[90,110],
[100,110],[110,110]])
#level 3
level.append([[70,50],[80,50],[90,50],[80,60],[110,70],[100,80],[110,80],[120,80],[90,90],[100,90],[110,90],
[120,90],[130,90],[50,70],[40,80],[50,80],[60,80],[30,90],[40,90],[50,90],[60,90],[70,90]])
#level 4
level.append([[70,40,1],[80,40,1],[90,40,1],[70,50,1],[80,50],[90,50,1],[70,60,1],[80,60],
[90,60,1],[50,70,1],[60,70,1],[70,70,1],[80,70],[90,70,1],[100,70,1],[110,70,1],[50,80],[60,80],
[70,80],[80,80],[90,80],[100,80],[110,80],[60,90,1],[70,90,1],[80,90,1],[90,90,1],[100,90,1],[80,100,1]])

run=1
intro=-50
ctintro=0

while intro<250:
    #intro=500
    img.clear(0)
    img.text((intro,120),u'Break by Wicker25',(ctintro,0,0))
    if intro<80:
        if ctintro<254: ctintro+=0.5
    else:
        if ctintro>0: ctintro-=0.5
    intro+=0.2
    handle_redraw(())
    e32.ao_yield()

while run:
    rand+=0.2+velsp
    if rand>1.2+velsp: rand=0.0

    velsp=levelcur/3

    if life==0:
        sleep(1)
        run=0

    img.clear(0)
    img.point((ballx,bally),0xff8800,width=5)
    img.text((x,y),u'((||||))',0x00ff00)

    for t in range(0,len(level[levelcur])):
        r=255
        g=0
        b=0
        if len(level[levelcur][t])>2 and level[levelcur][t][2]==1:
            r=0
            b=255
        img.rectangle((level[levelcur][t][0]+1,level[levelcur][t][1]+1,level[levelcur][t][0]+9,level[levelcur][t][1]+9),fill=(r,g,b))

    for t in range(0,len(level[levelcur])):
        levx=level[levelcur][t][0]
        levy=level[levelcur][t][1]
        if ballx>levx and ballx<levx+11.5 and bally>levy and bally<levy+11.5:
            img.text((levx+1,levy+9),u'#',0xffff00)

            if balldir[t]==1:
                xvel=-xvel
            if balldir[t]==-1:
                yvel=-yvel

            if len(level[levelcur][t])>2 and level[levelcur][t][2]>0:
                level[levelcur][t][2]-=1
            else:
                level[levelcur][t]=[-50,-50]
            score+=5
            break

    img.text((1,16),u'Score: '+unicode(score), 0xffffff)
    img.text((110,16),u'Life:',0xffffff)
    img.text((140,16),u'<>'*life, 0xffff00)

    handle_redraw(())
    e32.ao_yield()       

    balldir=[]

    for t in range(0,len(level[levelcur])):
        a=0
        b=0
        rs=0
        levx=level[levelcur][t][0]
        levy=level[levelcur][t][1]

        if (ballx-levx)%levx>(bally-levy)%levy:
            rs=1
        else:
            rs=-1

        balldir.append(rs)

    n_block=0
    for t in range(0,len(level[levelcur])):
        if level[levelcur][t][0]!=-50: n_block+=1

    if n_block==0:
        levelcur+=1
        sleep(2)
        ballx=90
        bally=170
        x=70
        y=200
        yvel=2.0+velsp
        xvel=2.0+velsp

    ballx-=xvel
    bally-=yvel

    if ballx<0 and xvel>0: xvel=-xvel
    if ballx>175 and xvel<0: xvel=-xvel

    if xvel>(2.4+velsp): xvel-=0.005
    if xvel<-(2.4+velsp): xvel+=0.005

    if bally<0:
        yvel=-yvel
    if bally>205:
        yvel=-yvel
        life-=1
        sleep(1)
   
    if ballx>x and ballx<x+35 and bally>y-18:
        yvel=2.3+velsp
        if direction==1: xvel=(2.3+rand)
        if direction==-1: xvel=-(2.3+rand)

    direction=0   
    if keyboard.is_down(EScancodeLeftArrow) and x>4: 
        x-=4+velsp
        direction=1

    if keyboard.is_down(EScancodeRightArrow) and x<140:
        x+=4+velsp
        direction=-1

write_score(score, name)

img.clear(0)
img.text((60,30),u'Best Score:',0xffff00)
bscore=read_score().split('\n')
for t in range(0,len(bscore)):
    img.text((35,50+t*15),unicode('   '+str(bscore[t])),0xffffff)

for t in range(0,10):
    img.text((8,50+t*15),u'  '*(1-(t+1)/10)+unicode(t+1)+u'.',0xffbb00)

handle_redraw(())
e32.ao_yield()
sleep(15)
