#!/bin/sh
# MP3 and WAV player gateway for muLinux
# (C) 2000 M. Andreoli

. /etc/path.conf
. /etc/cgi.lib

#set -x

BGCOLOR="#dddddd"

play()
{
cd ${directory} ||  error entering in ${directory} 
set -- $PLAY
for  f in $@ ; do
	lpr $f
done
log lpq
}

stop_queue()
{
lpq | rgrep bytes |
while read rank owner job rest; do
	lprm $job
done 
}

stop()
{
	stop_queue
}

refresh()
{
cd ${directory} 2>/dev/null || ( echo "no songs files" ; return 1) 
/bin/ls -1q *.mp3 *.MP3 *.wav 2>/dev/null |
while read f; do
(check_button "PLAY" $f no) && echo $f
done
}

main_form()
{
: ${directory:="/mass/mp3/bregovic"}
: ${VOL:=70}


html_start "muLinux MP3 machine"
cat <<END
<H1>MP3 player</A></H1>
<b>muLinux v`cat /etc/version`, Ip: $(fqn), $(date)</b>
<br>
Based on the BSD Printing Queue System.
<br>
<br>Did you configure the sound system? Didn't? Please, 
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=sound">
configure the sound system</a> 
</i>
<FORM METHOD="POST" ACTION="/cgi-bin/player.cgi">
<HR>
<br>
Directory: <input NAME="directory" type=input value="$directory">
$(button ACTION refresh)
$(button ACTION play)
$(button ACTION stop)
$(button ACTION status)
$(button ACTION volume-control)
$(popup VOL ${VOL} 10 20 30 40 50 60 70 80 90 100)
<HR>
$(refresh)
</FORM>
END
html_end -logo
mixer vol $VOL:$VOL > /dev/null
}

volume_control()
{
log "mixer vol $VOL:$VOL"
}

# MAIN
  
[ $# -ne 0 ] && QUERY_STRING="$@"	# demo mode
cgi_parse
[ -z "$ACTION" ] && ACTION=main_form

case $ACTION in
main_form)
	main_form
	;;
refresh*)
	main_form	
	;;
play*)
	play	
	;;
status*)
	log "mixer vol; lpq"
	;;
volume*)
	volume_control	
	;;
stop*)
	stop
	main_form
	;;
main)
	main_form
	;;
esac
