#!/bin/sh
# fax web gateway for muLinux
# (C) 2000 M. Andreoli

. /etc/path.conf
. /etc/cgi.lib

#set -x

BGCOLOR="#dddddd"

message()
{
if [ "$message" ] ; then
echo -e "$message"
else
cat <<END
A better way to send a professional fax with muLinux is using
the muLinux shared printer called "fax". Install this printer
in Windows using your preferred Postscript driver 
(e.g. AppleWriter, etc) and  put, somewhere in the text, the 
string %<the-phone-number>. Example: %058778625.

After that, you can send a fax using the fax-composer in WinWord,
and print the document referencing the new installed printer. 
NB: this requires gs Ghostscript installed.
END
fi
}
fax_form()
{
html_start "muLinux Fax Machine"
cat <<END
<H1><img src=/images/text.gif width=50>Create and send a FAX</A></H1>
<b>muLinux v`cat /etc/version`, Ip: $(fqn), $(date)</b>
<br>
<i>This form uses the /usr/bin/fax script, a rustic front-end
to the EFAX package. 
<br>Did you configure the modem? Didn't? Please, 
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=port">
configure the modem</a> and  
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=fax">
configure the fax</a> 

</i>
<FORM METHOD="POST" ACTION="/cgi-bin/fax.cgi">
<HR>
<font size=-1>
Device: $( set -- `/bin/ls -l /dev/modem`; shift 8; echo $@ )
</font>
<br>
<INPUT TYPE="submit" name=ACTION VALUE="Send"> to 
<input NAME="phone" type=input value="the-phone-number">
<INPUT TYPE="submit" name=ACTION VALUE="kill">
<INPUT TYPE="submit" name=ACTION VALUE="check-log">
<HR>
<TEXTAREA NAME="message" ROWS="10" COLS="70">
$(message)
</TEXTAREA>
</FORM>
END
html_end -logo
}

fax_send()
{
echo -e $message | tr 
 '\012' | /usr/bin/fax 123 1>>/var/log/fax.log 2>&1 &
html_start
cat <<END
<h1>Fax sending in background</h1>
Phone: $phone
<i>Please, check the logfile /var/log/fax.log </i>
<p>
Message: <br>
<hr>
<pre>
$(echo -e $message | tr ^M '\012')
</pre>
END
html_end -logo
}


# MAIN
  
[ $# -ne 0 ] && QUERY_STRING="$@"	# demo mode
cgi_parse
[ -z "$ACTION" ] && ACTION=fax_form

case $ACTION in
fax_form)
	fax_form
	;;
*Send*)
	fax_send
	;;
kill*)
	log "kill -9 `pidof efax`"
	;;
check-log)
	log "cat /var/log/fax.log | tail -20" 
	;;
main)
	fax_form
	;;
esac

