#!/bin/sh
# combust gateway for muLinux
# (C) 2000 M. Andreoli

. /etc/path.conf
. /etc/cgi.lib

#set -x

BGCOLOR="#dddddd"

main_panel()
{
: ${MEDIA:=CD-RW}
: ${SPEED:=2}
: ${BLANK:=no}
: ${BUS:=0}
: ${ID:=4}
: ${LUN:=0}
: ${WS:=/mass/tmp}

html_start "muLinux Rustic-Combust"
cat <<END
<H1> <img src=/images/cdrom.gif width=40>
Rustic Combust: audio and data CD copy</A></H1>
<i>Based on the cdrecord package, by  Jrg Schilling 
and the cdda2wav package, by  Heiko Eissfeldt</i>
<br>
<b>muLinux v`cat /etc/version`, Ip: $(fqn), $(date)</b>
<br>
<br>Did you configure the SCSI subsystem and the CDROM
support? Didn't? Please, 
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=scsi">
configure the SCSI subsystem</a> and 
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=cdrom">
configure the CDROM support</a> 
</i>
<hr>
<h3>Configuration:</h3>
<FORM METHOD="POST" ACTION="/cgi-bin/combust.cgi">
<br>Source Media type:
$(popup SOURCE "${SOURCE}" "audio" "data" )

<br>SCSI target:
$(popup BUS ${BUS} 0 1 2 3 4 5 6 7 8 )
$(popup ID ${ID} 0 1 2 3 4 5 6 7 8 )
$(popup LUN ${LUN} 0 1 2 3 4 5 6 7 8 )
Speed: $(popup SPEED "${SPEED}" 1 2 4 8 16 )

$(button ACTION scan_bus)
$(button ACTION check)
<h3>Operation:</h3>
$(button ACTION stop )
$(button ACTION eject )
$(button ACTION track-info)
<br>
$(button ACTION blank )
$(button ACTION "burn!")
<h3>Other:</h3>
Work space directory:
<input NAME="WS" type=input value="$WS"> 
<br>
$(button ACTION dump "dump") the CD-ROM 
$(radio_button OPT "wav" "yes") as WAV 
$(radio_button OPT "mp3" "no") as MP3 
</FORM>
END
html_end -logo
}

device()
{
echo "$BUS,$ID,$LUN"
}

check()
{
check_source
echo
echo "<b>Checking destination</b>..."
eject
}

eject()
{
cdrecord dev="$(device)" -eject
}

scan_bus()
{
cdrecord -scanbus
}

data_copy()
{
#blank
cdrecord -v dev=$(device) speed=$SPEED -isosize /dev/cdrom
cdrecord dev=$(device) -eject
}

get_tracks()
{
setlevel 1
cdir -n | rgrep tracks | sed "s/.*\([0-9][0-9]\) tracks/\1/"
setlevel 5
}

blank()
{
echo "Blanking the CD-RW ..."
case $SOURCE in
audio)
	cdrecord -v dev=$(device) speed=$SPEED -audio blank=fast
	;;
data)
	cdrecord -v dev=$(device) speed=$SPEED blank=fast
	;;
*)
	echo "error source=[$SOURCE]"
esac
}

dump()
{
check_source || return 1
cd $WS || (echo "error entering in $WS"; return 1)
TRACKS=$(get_tracks)
[ "$TRACKS" ] || (echo "no tracks! " ; return 1)
echo "Tracks: $TRACKS"


t=1
while [ $t -le $TRACKS ] ; do
echo "<b>Reading track $t of $TRACKS ...</b> "

case "$OPT" in
mp3)
	cdda2wav -t${t} -B -d0 -D /dev/cdrom - | lame - track-$t.mp3
	;;
wav)
	cdda2wav -t${t} -B -d0 -D /dev/cdrom
	;;
esac
	
t=$(expr $t + 1)
done

}

audio_copy()
{
#blank
TRACKS=$(get_tracks)
[ "$TRACKS" ] || (echo "no tracks! " ; return 1)
echo "Tracks: $TRACKS"
t=1	
while [ $t -le $TRACKS ] ; do
echo "<b>Reading track $t of $TRACKS ...</b> "
cdda2wav -t${t} -d0 -D /dev/cdrom - |\
cdrecord -v dev=$(device) speed=$SPEED -audio -pad -swab -nofix -
t=$(expr $t + 1)
done

echo
echo "<b>Fixating the CD ... </b> "
cdrecord -v dev=$(device) speed=$SPEED -audio -fix -eject
wave -c 220 1 ; wave -c 440 8
}


source_type()
{
setlevel 1
cdir > /tmp/st 2>/dev/null; rc=$?
setlevel 5
[ $rc -ne 0 ] && echo "none" && return 1

case "$(cat /tmp/st)" in
*DATA*)
	echo data;;
*)
	echo audio;;
esac

}

check_source()
{
echo "<b>Checking source CD-ROM ...</b>" 
type=$(source_type)

if [ "$type" =  $SOURCE ] ; then
echo "Success: a [$type] CD-ROM." ; return 0
else
cat <<END
Source CD-ROM is [$type], but you declared [$SOURCE].
END
return 1
fi
}

burn()
{
eval ${SOURCE}_copy &
}

stop()
{
kill -9 $(pidof cdda2wav)
kill -9 $(pidof cdrecord)
kill -9 $(pidof lame)
eject 
}

# MAIN
  
[ $# -ne 0 ] && QUERY_STRING="$@"	# demo mode
cgi_parse
[ -z "$ACTION" ] && ACTION=main_panel


case $ACTION in
main_panel)
	main_panel
	;;
check)
	log check	
	;;
scan_bus)
	log scan_bus	
	;;
burn*)
	check_source > /dev/null || (log check_source; exit)
	echo -e "Content-type: text/html\n\n"
	echo "<html><pre>"
	burn	
	;;
stop)
	log stop	
	;;
blank)
	log blank
	;;
dump*)
	echo -e "Content-type: text/html\n\n"
	echo "<html><pre>"
	dump &
	;;
eject)
	eject	
	log "echo Extract the disk"
	;;
track-info)
	log "cdir"
	;;
main)
	main_panel
	;;
esac


# End
