#!/bin/sh
# cdplayer gateway for muLinux
# (C) 2000 M. Andreoli

. /etc/path.conf
. /etc/cgi.lib
. /etc/utils

#set -x

BGCOLOR="#dddddd"


SYSTEM=$(include sound; echo $SYSTEM)
STATUS=$(setup sound status)


playing_status_sb()
{
case $(cdinfo) in
play) 
        echo "<font color=green>playing</font>"
	;;
*)
        echo "<font color=red>off</font>"
esac
}


playing_status_speaker()
{                  
if [ "`pidof cdda2wav`" ] ; then
        echo "<font color=green>playing</font>"
else
        echo "<font color=red>off</font>"
fi
}

playing_status()
{
eval playing_status_$SYSTEM
}

status()
{
cat <<END
Device: <b>$SYSTEM</b> Status: $(playing_status)
END
}


play_speaker()
{
log "cdda2wav -D /dev/cdrom -B -c1 -eN -a 2"
}

play_sb()
{
cdplay
main_panel
}

play()
{
eval play_$SYSTEM
}


stop_speaker()
{
kill -9 `pidof cdda2wav`
}

stop_sb()
{
cdstop
#(echo s; sleep 1 ; echo q) | playcd &
}


stop()
{
eval stop_$SYSTEM
}

pause()
{
cdpause
}

next()
{
(echo ">"; echo q) | playcd > /dev/null &
}


eject()
{
stop
cdeject
}

main_panel()
{
: ${VOL:=70}

html_start "muLinux CDPLAYER machine"
cat <<END
<H1> <img src=/images/cdrom.gif width=40>Audio CD player</A></H1>
<i>Based on the cdtool package, by Sven Oliver Moll
and the cdda2wav package, by  Heiko Eissfeldt</i>
<br>
<b>muLinux v`cat /etc/version`, Ip: $(fqn), $(date)</b>
<br>
<br>Did you configure the sound system? Didn't? Please, 
<a href="http://$(fqn):81/cgi-bin/adm.cgi?ACTION=view&RESOURCE=sound">
configure the sound system</a> 
</i>
<FORM METHOD="POST" ACTION="/cgi-bin/cdplayer.cgi">
<HR>
$(status)
<br>
$(button ACTION play)
$(button ACTION pause)
$(button ACTION stop)
$(button ACTION eject)
$(button ACTION track-info)
$(button ACTION volume-control)
$(popup VOL ${VOL} 10 20 30 40 50 60 70 80 90 100)
<HR>
</FORM>
END
html_end -logo
#mixer vol $VOL:$VOL >/dev/null
}

volume_control()
{
log "mixer vol $VOL:$VOL"
}

# MAIN
  
[ $# -ne 0 ] && QUERY_STRING="$@"	# demo mode
cgi_parse
[ -z "$ACTION" ] && ACTION=main_panel

setlevel 1

case $ACTION in
main_panel)
	main_panel
	;;
refresh*)
	main_panel	
	;;
play)
	play
	;;
status)
	log "mixer vol; lpq"
	;;
volume*)
	volume_control	
	;;
stop)
	stop
	main_panel
	;;
pause)
	cdpause	
	main_panel
	;;
next)
	next	
	main_panel
	;;
previous)
	previous	
	main_panel
	;;
eject)
	eject	
	log "echo Extract the disk"
	;;
track-info)
	log "setlevel 1; cdir; setlevel 5"
	;;
main)
	main_panel
	;;
esac

setlevel 5

# End
