#!/bin/sh
# adm.cgi, muRCP
# muLinux controlled by Web
# (C) M. Andreoli

. /etc/utils
. /etc/cgi.lib

# how to test the script:
#	adm.cgi "ACTION=action&RESOURCE=name"
# Ex:  adm.cgi "ACTION=view&RESOURCE=network"

#set -x


# PARAMETERS
RCP_VERSION="v0.4"

#LINK="LINK=#00FF00"
#VLINK="VLINK=#0080FF"

BGCOLOR="#dddddd"
TEXT=black

VERSION=$(cat /etc/version)

# FUNCTIONS

# JavaScript code: this is able to push the automatically
# the button "refresh"
 
javascript()
{
cat <<END
<script language=javascript>
function do_select(o)
{
var val;
alert("select="+o.name+" index="+o.selectedIndex + "val="+ o.options[o.selectedIndex].text);
}

</script>
END
}

uptime()
{
set -- `cat /proc/uptime`
h=`expr $1 / 3600` 
r=`expr $1 % 3600` 
min=`expr $r / 60` 
echo "${h}h $min m"
}


opt_list()
{
case $1 in
y|n)	echo "y n";;
yes|no)	echo "yes no";;
up|down)	echo "up down";;
esac
}


popup()
{
# input: name value list....

name=$1; value=$2
shift 2
sel=
cat <<END
<select name=$name> 
END
for x in $*
do
sel=
[ "$x"  =  "$value" ] && sel=selected
echo "<option $sel>$x"
done
echo "</select>"

}

cgilink()
{
label=$1; link=$2; 
[ -z "$link" ] && link="/cgi-bin/adm.cgi?$label"
echo "<a href=$link target=MAIN>$label</a>"
}

link()
{
label=$1; link=$2;
[ -z "$link" ] && link="$label"
echo "<a href=$link target=MAIN>$label</a>"
}



log()
{
title="$*"
html_start
echo "<pre>"
echo "<h1>$title</h1><hr>"
cat
cat <<END
<hr>
<h2>done.</h2>
END
}


#
# panels and forms

help_panel()
{
html_start
list=`/bin/ls -1q /usr/doc/help`

cat <<END
<center>
<h1>Select a topics</h1>
long wait ...
</center>
<hr noshade>
<font face=courier size=+1>
END

for h in $list
do
link $h /help/$h 
done
echo "</font>"

echo "<hr noshade>"
echo "<pre>"
/usr/games/fortune
echo "</pre>"

html_end
}


status_panel()
{
html_start

list=`cat /setup/model/custom`

cat <<END
<center>
<h1>Resources Status</h1>
long wait ...
</center>
<form action=/cgi-bin/adm.cgi method=GET>
<hr
>
<table width=95%>
<th></th><th></th><th></th>
END

for r in ${list}
do
info=$(include $r; echo $RESOURCE)

cat <<END
<tr>
<td></td>
<td><font size=+2><b>$r</b></font></td> 
<td>
END

val=`setup $r status`
popup $r $val up down 
echo "</td>"
echo "<td><em>$info</em></td>"
echo "</tr>"
done

echo "</table>"
echo "<center>"
button ACTION execute 
echo "</center>"
echo "</form>"
html_end
}


tool_panel()
{
html_start

s=-8

cat <<END
<center>
<img src=/images/mulinux5.gif width=100% alt=logo>
<font face=arial size=-2>
mu-RCP $RCP_VERSION (C) M. Andreoli 2000
</font>
</center>
<form action=/cgi-bin/adm.cgi method=get target=MAIN>
<img  src=/images/computer.gif width=20> 
<b>Resource</b><br>
`button ACTION help`
`button ACTION setup`
`button ACTION status`
<br>
`button ACTION save`
profile:<input name=PROFILE size=8 value=lock>
<br>
<img  src=/images/computer.gif width=20> 
<b>System Info</b>
<br>
<center>
<form action=/cgi-bin/adm.cgi method=get target=MAIN>
<table width=100% border=1>
<font face=Arial size=-3>
<tr><td>
`button boot`
`button version`
`button cpuinfo`
`button devices`
`button filesystems`
`button interrupts`
`button dma`
`button pci`
`button scsi-bus`
`button scsi-hd`
`button shares`
`button scsi-cdrom`
`button disks`

</tr>
</font>
</center>
END

echo "</tr>"
echo "</table>"
cat <<END
<img  src=/images/computer.gif width=20> 
<b>Control</b>
<br>
`button ACTION telnet`
`button ACTION halt`
`button ACTION reboot`

<p>
<b>Uptime: `uptime`</b>

END
echo "</form>"
html_end
}

sys_panel()
{

html_start
cat <<END
<table border=1 width=100%>
<tr><td>
<i>`hostname`, `fqn`</i> running <b>muLinux v$VERSION</b> -- `date`
</tr>
</table>
END
html_end

}

resource_view()
{
local r=$1
html_start
resource=$r
. /setup/fun/$resource.fun; default
include $resource
name=$RESOURCE
help=$(info)

list="keymap swap $(cat /setup/model/custom)"

cat <<END
<center>
<h1>$name</h1>
</center>
<form name=resource_form action=/cgi-bin/adm.cgi method=GET>
<b>Resource:</b>
<font size=+1 color=black>
`popup RESOURCE "$r" $list`
`button ACTION refresh`
</font>
Status: <font color=red size=+1>`setup $r status`</font>
<hr>
<p>
<center>
<font face=Arial size=-1>$help</font>
</center>
<hr>
<table width=70%>
<th></th><th></th><th></th>
END

for v in ${VAR_LIST}
do
cmd="val=\$$v"; eval $cmd

olist=`opt_list $val`

cat <<END
<tr>
<td></td>
<td><font size=-1><b>$v</b></font></td> 
<td><font face=arial >
END

if [ "$olist" ] ; then
	popup $v $val $olist
else
cat <<END
	<input name=$v size=30 type=input value="$val">
END
fi
echo "</font></td></tr>"
done

echo "</table>"
echo "<p><center>"
button ACTION  apply 
button ACTION  stop 
button ACTION  disable 
echo "</center>"

echo "</form>"
html_end
}

resource_stop()
{
r=$1
log "Stopping \"$r\" ..." <<END
`setup $r stop`
END
}

resource_disable()
{
r=$1
rf=/tmp/rf$$
echo "ACTION=unwanted" > $rf

log Disabling \"$r\" <<END
`setup $r stop; setup $r -$rf`
END

rm -f $rf
}


resource_restart()
{
r=$1
rf=/tmp/rf$$
> $rf

resource=$r
vars="`( . /setup/fun/$r.fun; default; echo ${VAR_LIST} )`"

set > /tmp/env       
for v in $vars
do
cmd="value=\$$v"; eval $cmd
echo "$v : $value"
echo $v="$value" >> $rf
done
echo "ACTION=configure" >> $rf
# load values

(
/bin/setup $r -$rf
#rm -f $rf
/bin/setup $r restart
) | log "Restarting \"$r\" ..." 

}


# TEST - TEST

col()
{
echo "<table width=100% border=1>"
while read x
do
echo "<tr><td>$x</td></tr>"
done
echo "</table>"
}

test_panel()
{
html_start

echo "<table width=100% border=1>"
echo "<td>"
cat <<END | col
a
b
END
echo "<td>"
cat <<END | col
1
2
3
END

echo "</table>"

html_end
}

# telnet session via Java applet

telnet_session()
{
html_start
cat <<END
<i>telnet `hostname`</i>

<applet
        CODEBASE="/java"
        ARCHIVE="jta20.jar"
        CODE="de.mud.jta.Applet"
        WIDTH=500 HEIGHT=300>
</applet>

END
html_end
}

# start and stop resources

change_status()
{
list=`cat /setup/model/custom`

echo "<h2>This process may take long time ...</h2>"
echo "<ul>"
for r in $list
do
old=`setup $r status`
eval new=\$$r


if [ "$old" != "$new" ] ; then
	echo  "<li><font size=+2><b>$r</b></font>: $old->$new"
	[ "$new" = up ] && new=
	[ "$new" = down ] && new=stop
	setup $r $new
fi	

done
echo "</ul>"

}

# MAIN


cgi_parse $@

case $ACTION in
tool) 	tool_panel
	;;
sys) 	sys_panel
	;;
setup)
	resource_view network
	;;
status)
	status_panel	
	;;
help)
	help_panel	
	;;
save)
	setup -s $PROFILE | log "Saving profile $PROFILE ..."
	;;
view|refresh)
	[ -z "$RESOURCE" ] && RESOURCE=$OPT
	resource_view $RESOURCE 
	;;
restart|apply)
	resource_restart $RESOURCE
	;;
stop)
	resource_stop $RESOURCE
	;;
disable)
        resource_disable $RESOURCE
        ;;
execute)
	change_status | log "Changing status"
	;;
# system info buttons
boot)
	dmesg | log "Boot log"
	;;
cpuinfo|version|filesystems|ioports|devices|interrupts|dma)
	cat /proc/$ACTION | log "$ACTION info"
	;;	
shares)
	smbclient -L localhost -N | log "SMB shares"
	#smbclient -L localhost -U nobody | log "SMB shares"
	;;
processes)
	ps aux | log "Active processes"
	;;
disks)
	(
	echo "<h2>Mounted:</h2>"
	df
	echo "<h2>Available:</h2>"
	setlevel 1
	fdisk -l
	setlevel 5
	) | log disks
	;;
pci|scsi-bus|scsi-cdrom|scsi-hd)
	/bin/scan $ACTION | log "Scanning $ACTION ..."
	;;
halt)
	/sbin/init 0 | log "Halting the system ..."
	;;
reboot)
	/sbin/init 6 | log "Rebooting the system ..."
	;;
telnet)
	telnet_session
	;;
auth|login)
	#html_start
	cat home.html
	#html_end
	;;
*)
	html_start
	echo "Unknown<br>$ACTION"
	html_end
	;;
esac
