#!/bin/sh

if [ -r /usr/script/suck.conf ] ; then
	RU=read_until
	. /usr/script/suck.conf
else
	. /root/mulinux/suck/suck.conf
	RU=/root/mulinux/tree/usr/bin/read_until
fi

. ${NET_LIB}

#--------------------
# local functions
#--------------------

get()
{
send "xhdr Message-Id $art\r"
expect *211*

b=
expect *$art* ; id=$b
expect . 

> $TAG.last

if [ -z "$id" ]; then
	msg "$art: bad article number."
	return 1
fi

send "article $id\r"
expect *220*

if [ $? -eq 0 ] ; then
	echo "From suck $group" > $TAG.last
	$RU ".
" | tr -d "
" >> $TAG.last
	return 0
else
	msg "$art: bad article number."
	return 1
fi

}


#--------------------
# suck.pro dialog
#--------------------

set -- `cat $TAG.stat`
group=$1; status=$2; max=$3


cat >> $LOGFILE <<END

==================================================================
Dialog started at: `date`
Server $NNTPSERVER, group[$group], status[$status], max[$max]
==================================================================

END


# dialog

expect *200*ready
send "mode reader\r"
expect *posting*ok*

send "group $group\r"
expect *211* ; first=$c; last=$d

msg "On this server: last $last, first $c" 


end=$last

if [ "$status" -lt 0 ] ; then
	tot=`expr 0 - $status`
	[ $tot -gt $max ] && tot=$max
else
	tot=`expr $last - $status`
	[ $tot -gt $max ] && tot=$max
fi

start=`expr $last - $tot`
start=`expr $start + 1`


#check bound

[ "$start" -lt "$first" ] && start=$first

msg "I require: $start-$end"

# append or rewrite?

if [ "$status" -lt 0 ] ; then
   > ${SPOOL_DIR}/$group
fi

count=0
art=$start;

#tot=`expr $end - $start`

echo "$group $last $max $count/$tot" > $TAG.stat

while [ 1 ] ; do

	[ "$art" -gt "$end" ] && break

	get $art

	if [ $? -eq 0 ] ; then
	count=`expr $count + 1`
	echo "$group $art $max $count/$tot" > $TAG.stat

	# filtering process [+++]
	sed -n '/^Status:/!P' $TAG.last >> ${SPOOL_DIR}/$group	
	fi

	art=`expr $art + 1`
done

echo "$group $art $max $count/$tot DONE!" > $TAG.stat
send "quit\r"

msg "Downloaded $count articles"

#end
