#!/bin/ash
# rustic `pr` (by M. Andreoli)
# 

#set -x

#TR=/root/mulinux/2/bin/tr
TR=tr

#Syntax

opt=$1

case $opt in
-h) echo "Usage (mu-pr): pr -[COLUMNS|h] [file]" ; exit ;;
-*) col=`echo $opt | tr -d '-'`; shift;;
*)  col=4;;
esac

f=$1

# Functions

fill()
{
dim=$1
dd bs=$1c conv=sync 2>/dev/null |\
$TR '\0' ' ' |\
$TR '\012' ' '
}

set -- 80 40 26 20 16 13 11 10 
t="\$$col"
dim=`eval echo $t`

count=0
for w in `cat $f`
do
echo $w | fill $dim
count=`expr $count + 1`

[ `expr $count % $col` = 0 ] && echo

done
echo
  
