#-------------------------
# VNC configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure the Xvnc server"
VAR_LIST="VNC_SERVER"
HIDDEN_LIST=""
MOD_LIST=""
VNC_SERVER='n'
}

info()
{
cat <<END
		  - VNC, Virtual Network Computing -

Xvnc (v3.3.1) provides all capabilities of a standard X server, but does 
not connect to a display for itself. You need a vncviewer to view and  
control the applications that run on the server. But the easiest way 
is to use a Java-enabled HTML browser (such as Netscape Navigator) to 
view the HTML page served by the VNCserver on your muLinux machine:

	            http://`hostname`:5801/

-- Xvnc requires X11 addon mounted (WM, xterm, etc.)
-- See "help", topics VNC
-- Other info here: http://www.uk.research.att.com/vnc/

END
}

requirement()
{
if [ "`which Xvnc`" ] && [ -x /usr/X11R6/bin/startx ]; then
	return 0
else
	echo "(VNC and X11 addons required)"
	return 1
fi
}

prepare()
{
resource=$1
prompt VNC_SERVER "$VNC_SERVER" "Start VNCserver at boot (y/n)?"
save -n $resource configure
}

unwanted()
{
vnc stop 2>/dev/null 1>&2
VNC_SERVER=n
configure
}

stop()
{
if [ "`which vnc`" ] ; then
echo "Shutting down VNC server ..."
vnc stop 2>/dev/null 1>&2
fi
}

configure()
{
repl=
if [ "$VNC_SERVER" = y ]; then
        repl="$repl; s/^#V/V/g"
        echo "Setting up VNC_SERVER."; sleep 1
else
        repl="$repl; s/^V/#V/g"
fi

cat /etc/inittab | sed "$repl" > /tmp/inittab
cp /tmp/inittab  /etc/inittab
rm /tmp/inittab

# update  inittab

[ "$RUNLEVEL" = 5 ]  && init q

}
