#------------------------------------
#  XFREE86 Monitor and Display Board  
#------------------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure Xfree86"
VAR_LIST=" SERVER WINDOW_MANAGER HORIZ_SYNC VERT_REFRESH \
COLOR_DEPTH GENERATOR VIDEORAM"
HIDDEN_LIST=""

# Parameter section
SERVER='VGA16'
WINDOW_MANAGER='fvwm95'
HORIZ_SYNC='29-60'
VERT_REFRESH='50-100'
COLOR_DEPTH='16'
VIDEORAM=2048
GENERATOR="-std 58.2"
}

info()
{
tell <<END

  	   -  XFree86: Monitor and Display Boards Setup -

This utility helps you to generate correct configuration
parameter for your monitor and for your display video board.

Remember:

	-- XWindow starts with "startx [window-manager]"
	-- You can re-generate the XF86Config file with "xf86config"
	-- You can probe your hardware with "xprobe"

END
}

modeline_info()
{
cat <<END
                - Rustic Modelines Computing Utility -

XFree86 uses so-called "modelines" to drive your display. To deal with
'modelines' requires to face with dot-clocks, horizontal and vertical
sync pulses, kHz and Mhz. Mulinux is able to compute the best modeline
using a rustic AWK script called 'mode.awk' (mode.awk -h for helps).
This script requires basically an option and a dotclock (in MHz).
Examples are: "-std 50.8", "-best 20-60", "-all 20-80", etc.
"-std" means "standard resolutions", such 640x480, 800x600, etc.
Using "-best", non-standard resolution are also generated.

Experience shows the VGA works in the clock range 20-35, and
SVGA in the range > 50, but this is only an hint of mine.
Please, experiment yourself with "xf86config -std range", then
restart X with 'startx'.

Finally, if you are an expert and know the correct modeline for your monitor,
you can enter it using the "-u" switch. Example:
                "-u 58.9 800 808 912 1040   600 602 610 630"
(those are only the last 9 numbers of a complete modeline).

Ok: as last resort, put your own XF86Config under /etc/X11, and good luck!
muLinux will overwrite this file only when you use the "-f" switch
in the current Setup: "setup -f xf86".

END
}


prepare()
{
resource=$1
echo
tell "Options: VGA16, SVGA, S3 (accelerated card), etc ..."
prompt SERVER $SERVER 

if [ -z "$(which XF86_${SERVER})" ]; then
	tell "The server required is not installed. abort."
	exit 1
fi

echo
tell "Options: fvwm95, afterstep, wm2, xfwm, ..."
prompt WINDOW_MANAGER $WINDOW_MANAGER

echo
tell "Please check monitor's specs, or leave them unchanged:"
prompt HORIZ_SYNC $HORIZ_SYNC
prompt VERT_REFRESH $VERT_REFRESH

echo
tell "Please check display board's specs, or leave them unchanged:"
tell "Setting COLOR_DEPTH=0,  depth is not used." 
tell "High COLOR_DEPTH means also low resolution." 
prompt COLOR_DEPTH $COLOR_DEPTH
tell "Video-RAM is in kBytes" 
prompt VIDEORAM $VIDEORAM

echo
prompt MI "y" "More Info about modeline concept? (y/n)"
[ "$MI" = y ] && modeline_info | muless -m -b "q to quit"

echo
tell "Please, put here the xf86config command line parameters"
prompt GENERATOR "$GENERATOR"
save -n $resource configure

tell <<END

	In the case XWindow fail using the supplied/generated modeline,
	you can run by hand the (rustic) experimental script "xprobe".
	This script try to compute the better modeline, fixed the Xserver
	and the COLOR_DEPTH (bpp).

	It is safe to run this script in a quiet machine, being prepared
	to reboot, if screen blocks. You can stop the server with the
	combination ctrl-alt-cancel.	

END
	prompt PROBE "n"  "Would You run the xprobe now? (y/n)"

case $PROBE in
y|Y)
	xprobe;;
esac

}

stop()
{
}

restart()
{
rm /etc/X11/XF86Config
configure
}

requirement()
{
if [ "`which xf86config`" ] ; then
        return 0
else
        echo "(X11 addons required)"
        return 1
fi
}

configure()
{
if [ "Z$force" = "Z-f" ] || [ ! -f /etc/X11/XF86Config ]; then
	xf86config
else
	:
	#echo "xf86config: Using the existing file /etc/X11/XF86Config"
fi
}
