#-------------------------
# syslogd, klogd 
#-------------------------

# syslog_remote feature provided
# by Dirk Heilemann <dirk.heilemann@telindus.de>


default()
{
ACTION=ask_the_user
RESOURCE="syslogd support"
VAR_LIST="SYSLOG_REMOTE"
HIDDEN_LIST=""
SYSLOG_REMOTE='n'
}

info()
{
tell <<END
			System Logging Utilities

Syslogd provides system utilities supporting system
logging and kernel message trapping: syslogd, klogd

	-- Please: look at the files /var/log/*.log
	   if something goes wrong with PPP, etc

END

}



requirement()
{
if [ "`which syslogd`" ]; then
	return 0
else
	echo "(SRV addon required)"
	return 1
fi
}

status()
{
pid=`pidof syslogd`

if [ "$pid" ]; then
	echo up
else
	echo down
fi

}


stop()
{
echo "`tell Stopping` `tell system log daemon`: klogd, syslogd ..."
kill -9 `pidof klogd`
kill -9 `pidof syslogd`
sleep 1
}

store()
{
#echo "Storing /etc/syslog.conf ..."
#cp /etc/syslog.conf /setup/cnf/store
}

prepare()
{
resource=$1
prompt SYSLOG_REMOTE "$SYSLOG_REMOTE" "Allow remote reception (yes/no)?"
save -n $resource configure
}


configure()
{
# prepare environment
> /var/log/wtmp


case $SYSLOG_REMOTE in
n|no)	echo -n  "`tell Starting` `tell system log daemon`: syslogd, klogd ..." 
	syslogd
        ;;
y|yes)	echo -n  "`tell Starting` `tell system log daemon with remote reception`: syslogd, klogd ..." 
	syslogd -r
        ;;
esac

[ "`which klogd`" ] && klogd 
tell "done."
}
