#-------------------------
# swap configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure swap space"
VAR_LIST="METHOD SOURCE SOURCE_PREMOUNT SOURCE_PREMOUNT_FS SIZE"
HIDDEN_LIST="MAGIC"
MOD_LIST=""

METHOD=e	# e=euristic
SOURCE='/linux.swp'
SOURCE_PREMOUNT='/dev/hda1'
SOURCE_PREMOUNT_FS='msdos'
SIZE='16000'
# Hidden section
MAGIC=''
}

info()
{
tell <<END
		     - Swap-space setup (OPTIONAL) -

You can choice a swap partition labelled "Linux swap" or a
file swap. If You plan to run XWindow, setup a swap is encouraged!

ALERT! POTENTIAL DAMAGE! If you are a *very* newbie or your machine
has enough RAM, skip this setup.

END
}

sanitize()
{
METHOD=e
save -n swap ask_the_user 
}

status()
{
set -- `cat /proc/meminfo | rgrep SwapTotal`
swap=$2

if [ "$swap" -eq 0 ] ; then
	echo down
else
	echo up
fi

}

stop()
{
swapoff /dev/swap 2>/dev/null
}

prepare()
{
resource=$1

while [ 1 ] ; do
if [ -x /bin/fdisk ] || [ -x /usr/bin/fdisk ]; then
setlevel 1
PAR=`fdisk -l 2>/dev/null | rgrep /dev | rgrep -v Disk| sed 's/\*/a/g'`
setlevel 5
tell "This is the partition table of your system:"
echo -e "$BRIGHT"
echo "   Device Boot   Begin    Start      End   Blocks   Id  System"
echo -e "$PAR"
echo -e "$NORMAL"
fi

tell <<END
You can:
	1) choice a swap partition labelled "Linux swap" (if any).	
	2) create a swapfile resident in some premounted
      	   Hard Disk, ex: a DOS partition. [for RAM-muLinux]
   	3) create a swapfile local to actual filesystem 
	   [for UMSDOS/EXT2/LOOP muLinux]
	0) continue without swap [for expensive machines]	
	e) Euristic Swap (the system try to swap automatically)
	   ^^^^^^^^^^^^^
END

set -- `mount | rgrep " / "` ; root_device=$1
set -- `df $root_device` ; root_device_size=$2

in_ram=`mount | rgrep " / " | rgrep ram`

if [ -z "$in_ram" ] ; then
tell << END

Your filesystem live on Hard-Disk, then I suggest solution 3)

END
fi

METHOD=0
prompt METHOD "$METHOD" "Your choice"

case $METHOD in
1)
	set -- `echo -e "$PAR" | rgrep swap`
	SOURCE=$1 
	prompt SOURCE "$SOURCE" "Enter your swap partition"
	SOURCE_PREMOUNT=

echo -e "$BRIGHT$YELLOW"
tell <<END
	
	ALERT! This choice plough the $SOURCE partition completely!
			!! any data will be loss !!

END
echo -e "$NORMAL"
	;;
3)
	prompt SOURCE "/swap/linux.swp" "Enter swapfile name"
	SOURCE_PREMOUNT=
	;;
2)
	set -- `echo -e "$PAR" | rgrep DOS`
	SOURCE_PREMOUNT=$1
	prompt SOURCE_PREMOUNT "$SOURCE_PREMOUNT" \
        "Enter PARTITION containing swapfile"
	prompt SOURCE_PREMOUNT_FS msdos \
        "Enter $SOURCE_PREMOUNT fs type"
        prompt SOURCE "/linux.swp" "Enter swapfile name"
	;;
0)
	SOURCE=
	return 1
	;;
e)	# euristic swapping :-)
	save -n $resource configure
	return 0
	;;
esac	
	case "$SOURCE" in
	*/dev/hd*|*/dev/sd*) SIZE= ;;
	esac

	prompt SIZE  "$SIZE" "Enter swapfile size (in KB) or blank"

echo
prompt ans "n" "Are you happy with this configuration? (y/n)"

# a sort of "rustic" signature of root device
# I want to detect root device changes

MAGIC="${root_device} ${root_device_size}"

# save config.

if [ "$ans" = y ] ; then 
	save -n $resource configure
	break
fi

done

}

configure()
{
if [ "$METHOD" = e ] ; then
	. /etc/rc/auto-swap
	return 
fi

[ -z "$SOURCE" ] && echo "System without swap." && return 1

# Consistency check

set -- `mount | rgrep " / "` ; root_device=$1
set -- `df $root_device` ; root_device_size=$2
set -- $MAGIC

root_changed=
if [ "$1" != ${root_device} ] || [ "$2" != ${root_device_size} ]; then
	root_changed=yes
fi


if [ "$root_changed" ] && \
[ "$root_device" != "${SOURCE_PREMOUNT}" ] && \
[ "$method" != 1 ] ; then
cat <<END

	Root device is changed since last swap setup (maybe this is 
	a new cloned system?), therefore this old setting are disabled
	for safety reasons and to avoid incosistency. 
 
END
exec setup -f swap
return 1
fi


# add FS support

case "Z${SOURCE_PREMOUNT_FS}Z" in
ZZ|ZmsdosZ|Zext2Z)
        ;;
ZvfatZ)
        ;;
esac

	swapoff /dev/swap 2>/dev/null

#  premount

POINT=/swap
mkdir -p $POINT

if [ "${SOURCE_PREMOUNT}" ]; then

	# already mounted?
	set -- `mount | rgrep ${SOURCE_PREMOUNT}`

	if [ "$1" ] ; then
                POINT=$3
        else

       		mount ${SOURCE_PREMOUNT} $POINT 
		if [ $? -ne 0 ] ; then
		echo
		echo "swap inconsistency: cannot mount ${SOURCE_PREMOUNT}."
		echo "run 'setup -f swap' manually."
		echo
		exit 1 
		fi
	fi
        case ${SOURCE} in
        /*) source=${POINT}${SOURCE};;
        *)  source=${POINT}/${SOURCE};;
        esac

else
        source=${SOURCE}
fi

# create link /dev/swap

	cd /dev
	swapoff swap 2>/dev/null
	rm -f swap
	ln -s $source swap

# there is Linux swap signature?

magic=`dd if=${source} bs=1c skip=4086 count=10 2>/dev/null`

if [ "$magic" != SWAP-SPACE ] || [ "$ACTION" = ask_the_user ] 
then

	if [ "$SIZE" ] ; then
	tell "Creating swapfile ..."
	dd if=/dev/zero of=/dev/swap bs=1k count=$SIZE
	fi

	mkswap /dev/swap $SIZE
	sync 
fi
	swapon /dev/swap

}
