#-------------------------
# SVGAlib configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure SVGAlib"
VAR_LIST=""
HIDDEN_LIST=""
}

info()
{
cat <<END
			- svgalib v1.2.13 setup -

This is a low level graphics library for Linux, originally
based on VGAlib 1.2 by Tommy Frandsen. VGAlib support  a
number  of  standard  VGA graphics modes, as well as Tseng
ET4000 high resolution 256-color modes. As of now, support
for  many  more  chipsets  has  been  added.

 -- SVGAlib is required by svncviewer, etc.
 -- SVGAlib is NOT related to X Window

END
}

requirement()
{
if [ -r /etc/vga/libvga.config ]; then
	return 0
else
	echo "(VNC addon required)"
	return 1
fi
}

store()
{
if [ -r /etc/vga/libvga.config ] ; then
	echo "Storing /etc/vga/libvga.config ..."
        cp /etc/vga/libvga.config /setup/cnf/store
fi
}


prepare()
{
resource=$1

echo "Probing PCI devices ..."

echo -e $YELLOW
pciprobe
echo -e $NORMAL

cat <<END
	
	:)
	There is a config file for SVGALIB, named /etc/vga/libvga.config.
	Any changes to this file will be saved in the Setup environment.

	You can edit this file now using "vi" text-editor, or later,
	with your preferred editor. Anycase, exit from "vi" with ESC:q.

	Do you want edit this file now?

END
	prompt edit "y" "y/n"

	if [ "$edit" = y ] ; then
		vi /etc/vga/libvga.config
	fi

save -n $resource configure
}

configure()
{

if [ -r /setup/cnf/store/libvga.config ] ; then
	cp /setup/cnf/store/libvga.config /etc/vga
fi

}
