
#-------------------------
# IDE standby timeout 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="set standby (spindown) timeout for HD"
VAR_LIST="DRIVES"
HIDDEN_LIST=""
MOD_LIST=""
DRIVES=''
}

info()
{

cat <<END
		  	  -- Quiet Computers Setup -- 

	If You run in RAM, you would wish to spin down harddisks
	at fixed timeout. muLinux uses a stripped version of "hdparm"
	utility for that. See "hdparm -h".
	
	Useful for laptop's battery saving.

END

}


prepare()
{
resource=$1

PAR=`fdisk -l 2>/dev/null | rgrep /dev | rgrep -v Disk| sed 's/\*/a/g'`

echo "This is the partition table of your system:"
echo -e "$BRIGHT"
echo "   Device Boot   Begin    Start      End   Blocks   Id  System"
echo -e "$PAR"
echo -e "$NORMAL"

set -- `echo -e "$PAR" | rgrep "DOS"`
DOS_DEVICE=$1

[ -z "$DRIVES" ] && DRIVES="$DOS_DEVICE:10s"

cat <<END

	You can set standby timeout for a list of drives with
	this syntax: "drive:timeout drive:timeout ...".  Ex: 

		 /dev/hda:y /dev/hdb:30m /dev/hdc:60s
	
	Values allowed for timeout are:

		0	(disable spindown)
		5s, 10s, ... (multiples of 5 secs) 
		30m, 60m, ... (multiples of 30 mins) 
		253	(vendor specific value)
		y	(spindown immediately)

END

echo "Enter the drive's list or \"\" to disable"
prompt DRIVES "$DRIVES"

save -n $resource configure
}


configure()
{
save=$IFS

for d in $DRIVES
do
IFS=":" ; set -- $d; drive=$1; timeout=$2; IFS=$save

case $timeout in
y)
	opt="-y"
	;;
*m)
	t=`echo $timeout| tr -d m`
	mult=`expr $t / 30` 
	v=`expr 240 + $mult`
	opt="-S $v"
	;;
*s)
        t=`echo $timeout| tr -d s`
        v=`expr $t / 5`
        opt="-S $v"
        ;;
*)
	opt="-S $timeout"
	;;
esac

hdparm $opt $drive

done


}

