#-------------------------
# SSH  - Secure Shell daemon
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to configure ssh (Secure Shell) daemon"
VAR_LIST=""
HIDDEN_LIST=""
MOD_LIST=""
}

info()
{
tell <<END
		- ssh (Secure Shell) daemon setup -

SSH (Secure  Shell client)  is a  program for logging into a remote
machine and for executing commands in  a  remote  machine (see ssh -h).
SSHD is the daemon program for ssh (NEW). 

Together these programs are intended  to  replace  rlogin and rsh,
and provide secure  encrypted  communications  between  two  untrusted
hosts over an insecure network. 

SCP copies files beetwen hosts on a network using ssh for data
transfer: it is intended to replace rcp, ftp, etc. See "scp -h"

	-- See the file /usr/doc/help/ssh for some tip.

END
}

requirement()
{
if [ "`which sshd`" ]; then
	return 0
else
	echo "JVM addon required)"
	return 1
fi
}

store()
{
return 0  # disabled
echo "Storing /etc/ssh, /root/.ssh ..."
cp -a /etc/ssh /setup/cnf/store 2>/dev/null
#cp -a /root/.ssh /setup/cnf/store
}


prepare()
{
resource=$1
generate_host_key
generate_user_key
save -n $resource configure
}

generate_host_key()
{
clear
echo "Generating SSH RSA host key (this is slow, please be patient)... "        /usr/bin/ssh-keygen -f /etc/ssh/ssh_host_key -N ''
sleep 1
ssh-keygen -f /etc/ssh/ssh_host_key -N ''
echo "Done."
}

generate_user_key()
{
clear
echo "Generating SSH RSA public/private user key ... "
sleep 1
ssh-keygen 
echo "Done."
}



status()
{
if [ "`pidof sshd`" ] ; then
        echo up
else
        echo down
fi
}

start()
{
echo -n "Starting Secure Shell server: sshd"
sshd
pid=$(pidof sshd)
echo " ($pid)"
}

stop()
{
echo -n "Stopping Secure Shell server: sshd "
pid=$(pidof sshd)
(
kill -9 $pid
) 2>/dev/null
[ -z "$pid" ] && pid="was down"
echo " ($pid)."
}

restart()
{
stop
start
}

configure()
{
[ ! -f /etc/ssh/ssh_host_key ] && generate_host_key
[ ! -d /root/.ssh ] && generate_user_key
start
}

# End
