#--------------------------
#  SOUND configuration 
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="Sound support"
VAR_LIST="SYSTEM IO IRQ DMA DMA16 VOL"
HIDDEN_LIST=""
MOD_LIST="misc/sound"

SYSTEM='speaker'
IO='220'
IRQ='10'
DMA='1'
DMA16='0'
VOL='70'
}

info()
{
tell <<END
          		  - Sound module -

Standard muLinux distribution supports SoundBlaster ISA cards only.
Changing  port, irq, and dma's of the sound blaster driver at runtime
with scripts, is a contribution by Miguel Angel <maacruz@navegalia.com>.

In addiction, muLinux support PC-Speaker module (by Michael Beck). 
The quality of playing heavyly depends on your PC-Speaker, so don't 
expect too much. This device should work with most utilities written 
for /dev/dsp or /dev/audio and digitized voice applications. 
Try this if you don't have a SoundBlaster card.

-- Play CD with "playcd".
-- Play a WAV with "vplay" and record with "vrec" 
-- Say digitized sentence with "say sentence" 


END

}

sb_setup()
{
tell <<END

	Please, check your Sound Card manual:

        IO may be 220 or 240
        IRQ one of 3,5,7,9,10,11,12
        DMA may be 0,1 or 3
        DMA16 may be 5,6 or 7  ( 0 to disable)

	A part from IRQ and IO, you must try some right combination
	of DMA and DMA16 with try-and-error. 

END

        prompt IO "$IO"
        prompt IRQ "$IRQ"
        prompt DMA "$DMA"
        prompt DMA16 "${DMA16}"

}

sb_irq_probe()
{
for IRQ in 5 7 9 10 11 12
do
	echo "SoundBlaster: Probing ======> irq=$IRQ, io=0x$IO ..."
	patch_module
	(rmmod sound; load_module misc/sound) 2>/dev/null > /dev/null
	sleep 1
	check_sound_sb && return 0 
done
return 1
}

sb_probe()
{
for IO in 220 240 338 370 543
do
sb_irq_probe && return 0
done
return 1
}

probe()
{
sb_probe
}

stop()
{
case $SYSTEM in
sb)
	rmmod sound 2>/dev/null && tell "SB driver removed."
	;;
*speaker*)
	rmmod pcsnd 2>/dev/null && tell "PC-speaker driver removed."
	;;
esac
}

prepare()
{
resource=$1

echo
tell <<END
Do You want:
	
	sb) SoundBlaster sound module (play RAW, WAV and CD) 
	speaker) PC-Speaker   sound module (play RAW and WAV)

END

prompt SYSTEM "${SYSTEM}" "Your choice (sb/speaker)" 

case $SYSTEM in
sb)
	prompt PROBE "y" "Would you auto-probe soundcard IRQ? (y/n)"
	rc=
	[ $PROBE = y ] && sb_probe && rc=$? 
	if [ "$rc" -eq 0 ] ; then 
	echo -e $GREEN
	echo "Success: IO=$IO IRQ=$IRQ DMA=$DMA DMA16=${DMA16}" 
	echo -e $NORMAL
	else
	echo -e $RED
	echo "Fail: please, provide values." 
	echo -e $NORMAL
	IO=220	
	fi
	sb_setup
	;;
esac

save -n $resource configure
}

make_links()
{
# link in /dev
# Note: VoxWare device D are renamed in voxD.
# pcsp are renamed pcdsp. So {vox*, pc*} form two
# linked groups.

cd /dev
list="audio dsp mixer"
echo "make audio links ..."
for d in $list
do
        rm -f $d
        ln -s ${pre}${d} ${d}
done
}


check_sound_sb()
{
#set -x
sndstat_entry=`cat /dev/sndstat 2>/dev/null| sed -n "/^[(]Sound/P"`
if [ -z "$sndstat_entry" ] ; then
sndstat_entry=`cat /dev/sndstat 2>/dev/null| sed -n "/^Sound Blaster/P" 2>/dev/null`
sndstat="OK"
else
sndstat="FAIL"
fi
irq_entry=`cat /proc/interrupts | sed -n "/[Ss]ound [Bb]laster/P" 2>/dev/null`


snd=FAIL
[ "$sndstat" = OK ] && [ "$irq_entry" ] && snd=OK
rc=$?

echo -e "$sndstat_entry: ${BRIGHT}$snd${NORMAL}"
return $rc
}

check_sound_speaker()
{
lsmod | rgrep pcsnd >/dev/null
rc=$?
if [ $rc -eq 0 ]
then
	echo up
else
	echo down
fi
return $rc
}


status()
{

check_sound_$SYSTEM 2>&1 >/dev/null
if [ $? -eq 0 ] ; then
	echo up
else
	echo down
fi
}

# split hex 0xhhll in hh,ll (but in decimal)
split_bytes()
{
d=`expr d $1`
r=`expr $d % 256`
d=`expr $d - $r`
n=`expr $d / 256`
echo "$n,$r" 
}

patch_module()
{
#set -x
. /etc/snddrvaddr
IOL=$PORTADDR
IOH=`expr $PORTADDR + 1`
MODULE="/lib/modules/`uname -r`/misc/sound.o"

hl=`split_bytes 0x$IO`
ioh=`Array $hl 1`
iol=`Array $hl 2`

port_spec="$IOH $ioh $IOL $iol"
irq_spec="$IRQADDR $IRQ"
dma_spec="$DMAADDR $DMA"
if [ "$DMA16" ]; then
	dma16_spec="$DMA16ADDR ${DMA16}"
fi

poke $MODULE $port_spec $irq_spec ${dma_spec} ${dma16_spec}
}

set_mixer()
{
# set volume

if [ "`which mixer`" ] ; then
        mixer vol $VOL:$VOL
fi

}

play_something()
{
wave 4 1 || return 1
if [ -f /usr/local/demos/morning.wav ] ; then
	vplay -w /usr/local/demos/morning.wav 2>/dev/null &
else
	wave 220 4 &
fi
}

configure()
{

case "$SYSTEM" in
sb)
	(
	locate_module misc/sound 
	) 2>/dev/null 1>&2

	patch_module	
	rmmod sound 2>/dev/null 
	load_module misc/sound 
	pre="vox"
	check_sound_sb; rc=$?
	if [ $rc -eq 0 ] ; then
		make_links
		#( VOL=20; set_mixer; play)
		set_mixer
	fi
	;;
speaker)
	load_module misc/pcsnd
	pre="pc"
	make_links
	set_mixer
	;;
esac

# play_something

# File permissions under /dev 

chown root.sys /dev/vox*
chmod ug+w /dev/vox*
chown root.sys /dev/pc*
chmod ug+w /dev/pc*


}
