#-------------------------
#  smbd (server) 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="smbd (Samba) support"
VAR_LIST="INTERFACES SUPERMOUNT CHECK READ_ONLY"
HIDDEN_LIST=""
MOD_LIST=""

INTERFACES='eth0 eth1 ppp0 ppp1 lo'
SUPERMOUNT='n'
CHECK='y'
READ_ONLY='y'
}

info()
{
tell <<END
		- smbd and nmbd (Samba) servers -

smbd  is  a server that can provide most SMB services. The
server provides filespace and printer services to  clients
using  the  SMB protocol. This is compatible with the Lan-
Manager protocol,  and  can  service  LanManager  clients.
These  include  MSCLIENT  3.0  for  DOS, Windows for Work-
groups, Windows 95, Windows NT, OS/2, DAVE for  Macintosh,
and smbfs for Linux.

Samba is configured to become a Master Browser and for WINS
support. Configuration files are in /etc/samba.  

END
}

sanitize()
{
SUPERMOUNT=n
save -n $1 ask_the_user
}

requirement()
{
if [ "`which smbd`" ]; then
        return 0
else
	echo "(SRV addon required)"
        return 1
fi

}

unwanted()
{
kill -9 `pidof smbd` 2>/dev/null
kill -9 `pidof nmbd` 2>/dev/null
kill -1 `pidof inetd` 2>/dev/null
}

status()
{
if nc -z localhost 139
then
	echo up
else
	echo down
fi
}

store()
{
# /etc/samba is save anymore: too big
return 0
in_ram=`mount | rgrep " /" | rgrep ram` 
if [ -f /etc/samba/custom ] && [ "$in_ram" ] ; then
echo "`tell Storing` /etc/samba ..."
cd /etc/samba
tar -cf- * > /setup/cnf/store/smbconf.tar
fi
}


stop()
{
unwanted
tell "Shutting down SMB service: smbd, nmbd ..."
kill -9 `pidof smbd` 2>/dev/null
kill -9 `pidof nmbd` 2>/dev/null
if [ "$SUPERMOUNT" = y ] ; then
	tell "Umount disk shares ..."
	supermount umount >/dev/null
fi
}

prepare()
{
resource=$1
tell <<END

	The INTERFACES Samba option takes a list of interface 
	names, so the daemon can properly handle browsing on
	all network interface. If it is left blank, Samba will
	attempt to find a primary interface, but won't attempt
	to configure more than one interface.

	Example is   

		INTERFACES="eth0 ppp0"

	IP and netmask are dynamically assigned.

END
	prompt INTERFACES "$INTERFACES"

tell <<END

	If you answer 'y' to next question, when Samba Server is started,
	every hard-disk partitions and CDROMs in this PC is mounted,
	classified by OS type and kind of interface (SCSI or IDE). 

END
	prompt SUPERMOUNT "$SUPERMOUNT"
	if [ "$SUPERMOUNT" = y ]; then
	prompt CHECK "$CHECK" "FS-Check every Linux EXT2FS disks (y/n)?"
	prompt READ_ONLY "$READ_ONLY" "mount read-only (y/n)?"
	fi
		
save -n $1 configure
}

create_disks_share()
{
cat > /etc/samba/disks <<END
[disks]
   comment = All disks on this PC 
   browseable = yes
   writable = yes 
   public = yes
   locking = no
   path = /tmp/samba
END
}



configure()
{
# paranoia

mkdir -p /var/samba
mkdir -p /var/samba/locks
mkdir -p /tmp/nothing
echo "Hello! "> /tmp/nothing/nothing.txt
echo "Ciao! "> /tmp/nothing/niente.txt
echo "Bonjour! "> /tmp/nothing/rien.txt
echo "Ave! "> /tmp/nothing/nihil.txt

# restore SMB conf  (-- disabled --)
#in_ram=`mount | rgrep " /" | rgrep ram`
#conf=/setup/cnf/store/smbconf.tar
#if [ -f $conf ] && [ "$in_ram" ]; then
#	echo "Restoring Samba configuration files ..."
#	(cd /etc/samba; tar  -xf $conf)
#fi

# set interfaces in /etc/samba/custom

int=""
for i in $INTERFACES
do
ip=`get_ip $i`
mask=`get_mask $i`
[ "$ip" ] && [ "$ip" != "0.0.0.0" ] && int="$int $ip/$mask"
done

if [ "$int" ] ; then
	tell "Samba: using interfaces %s." | printf -r "$int"
	interface_spec="interfaces= $int"
else
	interface_spec="interfaces= $int"
fi
	
cat /etc/samba/custom | grep -v interfaces > /tmp/custom
echo "$interface_spec" >> /tmp/custom
cp /tmp/custom /etc/samba/custom
rm -f /tmp/custom

# create disks shares

if [ "$SUPERMOUNT" = y ] ; then
	create_disks_share 
	[ "$CHECK" = y ] && tell "Checking disks ..." && \
			supermount check > /dev/null
	supermount read_only=${READ_ONLY} mount > /dev/null
fi

# start/reload nmbd

pid=`pidof nmbd`
if [ "$pid" ] ; then
	kill -1 $pid
else 
	nmbd -a -D
fi

pid=`pidof smbd`
if [ "$pid" ] ; then
        kill -1 $pid
else
     	smbd -d2 -D 
fi

# give an handshake

if [ "`which smbclient`" ] ; then
	smbclient -L localhost -N 2>/dev/null | rgrep Domain=
fi

}
