#-------------------------
# Config. server side
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to change the servers/daemons setup"
VAR_LIST="X_SERVER JOB_SCHEDULER WEB_SERVER RING_SERVER SERIAL_SERVER
DIALIN_SERVER FAX_SERVER TELNET_SERVER IDENTD_SERVER VCM_SERVER"
HIDDEN_LIST=""
MOD_LIST=""

X_SERVER='n'
JOB_SCHEDULER='y'
WEB_SERVER='y'
RING_SERVER='n'
SERIAL_SERVER='n'
DIALIN_SERVER='n'
FAX_SERVER='n'
TELNET_SERVER='n'
IDENTD_SERVER='y'
VCM_SERVER='n'
}

info()
{
cat <<END

  	 		- SERVERS & DAEMONS -

Now you will be asked to configure some built-in muLinux rustic
servers, starting via init(8) at runlevel 5 (see /etc/inittab).

If you wish, later, to change some server status, do this:

	# setup -f server [change somethings ]
	# init q  [ re-read /etc/inittab ] 

See 'help' for other info.

	WARNING: server accessing the modem port can conflict with 
	other dialin server or with PPP dialout protocol.

END
}

stop()
{
#stop-daemon atd in.seriald in.faxd in.telnetd
}

prepare()
{
resource=$1

# ----- X server

prompt X_SERVER "${X_SERVER}" "Do You wish to start \
XWindow server at any boot (y/n)?"

# ----- Job Scheduler 
cat <<END

	JOB-SCHEDULER daemon allow You to submit job for a deferred
	execution. Example:

		echo "ppp-on" | at 28 17:15

END
prompt JOB_SCHEDULER "$JOB_SCHEDULER" "Do you want atd daemon running (y/n)?"

# ----- RING server

cat <<END

	Enabling the RING_SERVER, your machine wait for characters
	to become available from the modem (indicating an incoming
	call) and execute the /etc/ring.cmd command.

END
prompt RING_SERVER "$RING_SERVER" "Do you want RING server running (y/n)?"

# ----- SERIAL server

cat <<END

	Enabling the SERIAL_SERVER, a getty program will be run to
	initialize the terminal driver and start a login process
	on the serial port. This is usefull for direct conection
	via null-modem cable (I added tty.exe in DOSTOOLS.tgz if You 
	want to test  DOS-LINUX connectivity).
	
END
prompt SERIAL_SERVER "$SERIAL_SERVER" "Do you want SERIAL server running (y/n)?"


cat <<END
                                                                                
        Enabling the DIALIN_SERVER, a getty program will be run to
        initialize the modem in sane state and start a login process with
	telephonics counterpart. I tested this with BITCOM and HYPER
	TERMINAL on Window$-95 machines.
                                                                                
END
prompt DIALIN_SERVER "$DIALIN_SERVER" "Do you want DIALIN_SERVER running (y/n)?"       


cat <<END

        Enabling the FAX_SERVER, your machine wait for characters to
	become available form the modem and start fax reception.

END
prompt FAX_SERVER "$FAX_SERVER" "Do you want FAX_SERVER running (y/n)?"

cat <<END

        Enabling the TELNET_SERVER, you can connect to this host 
	with telnet interactive protocol.
	Please, do not enable this fake telnetd if you plan to
	use a true telnetd server.

END
prompt TELNET_SERVER "$TELNET_SERVER" "Do you want TELNET_SERVER running (y/n)?"

cat <<END

        The (rustic) IDENTD_SERVER  implements the TCP/IP standard
	IDENT user idenfitication protocol (RFC-1413)

END
prompt IDENTD_SERVER "$IDENTD_SERVER" "Do you want IDENTD_SERVER running (y/n)?"

cat <<END

	The VCM_SERVER is a simple and rustic up-right-corner monitor,
	for Linux consolles. It shows time/date, free memory, uptime and 
	received/trasmitted packets across Ethernet interface.

	Please, issue "vcm" to see how it works.

END
prompt VCM_SERVER "$VCM_SERVER" "Do you want a VCM_SERVER running (y/n)?"


# finish
save -n $resource configure
}


configure()
{

if [ "$X_SERVER" = y ]; then
        repl="$repl; s/^#X/X/g"
	echo "Setting up X_SERVER."; sleep 1
else
        repl="$repl; s/^X/#X/g"
fi

if [ "$JOB_SCHEDULER" = y ]; then
	repl="$repl; s/^#AT/AT/g"
	echo "Setting up deferred job scheduler."; sleep 1
else
	repl="$repl; s/^AT/#AT/g"
fi
	
#if [ "$WEB_SERVER" = y ]; then 
#	repl="$repl; s/^#W3/W3/g"
#	echo "Setting up web server."; sleep 1
#else
#	repl="$repl; s/^W3/#W3/g"
#fi

if [ "$RING_SERVER" = y ]; then
        repl="$repl; s/^#R/R/g"
	echo "Setting up ringd server."; sleep 1
else
        repl="$repl; s/^R/#R/g"
fi

if [ "$SERIAL_SERVER" = y ]; then
        repl="$repl; s/^#SS/SS/g"
	echo "Setting up SERIAL server." ; sleep 1
	
else
        repl="$repl; s/^SS/#SS/g"
fi

if [ "$DIALIN_SERVER" = y ]; then 
        repl="$repl; s/^#DS/DS/g"
	echo "Setting up DIALIN_SERVER server."; sleep 1
else
        repl="$repl; s/^DS/#DS/g"
fi

if [ "$FAX_SERVER" = y ]; then
        repl="$repl; s/^#FS/FS/g"
	echo "Setting up FAX server." ; sleep 1
else
        repl="$repl; s/^FS/#FS/g"
fi

if [ "$TELNET_SERVER" = y ]; then
        repl="$repl; s/^#T\([0-9]\)/T\1/g"
        echo "Setting up TELNET server." ; sleep 1
else
        repl="$repl; s/^T\([0-9]\)/#T\1/g"
fi

if [ "$IDENTD_SERVER" = y ]; then
        repl="$repl; s/^#ID/ID/g"
        echo "Setting up IDENTD server." ; sleep 1
else
        repl="$repl; s/^ID/#ID/g"
fi

if [ "$VCM_SERVER" = y ]; then
	echo "Starting VCM server on console #2 ..."
	vcm 2 &
else
fi



cat /etc/inittab | sed "$repl" > /tmp/inittab
cp /tmp/inittab  /etc/inittab
rm /tmp/inittab

# update  inittab

init q

}
