#--------------------------
#  SENDMAIL configuration 
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="Sendmail (SMTP) support"
VAR_LIST="SMARTHOST SMTP_PORT EMAIL FULL_NAME RUN_AS_DAEMON DEBUG_MODE INTERVAL"
HIDDEN_LIST=""
MOD_LIST=""

SMARTHOST='box.tin.it'
SMTP_PORT='25'
EMAIL='craxi@sanvittore.it'
FULL_NAME='Bettino Craxi'
RUN_AS_DAEMON='y'
DEBUG_MODE='n'
INTERVAL='10m'
}

info()
{

tell <<END
		        - Sendmail (SMTP) Setup -

This info are related to your outgoing mail headers (SMTP prot.).  
You can specify your FULL_NAME and your official EMAIL address.

Depending of availability, the Smail daemon will be used,
otherwise the internal, rustic 'sendmail' script will take place.

  -- Use 'mail' command for generic mail processing
  -- Log in /var/log/sendmail.log

END

}

have_smail()
{
[ "`which smail`" ]
}


prepare()
{
resource=$1

prompt EMAIL "$EMAIL"
prompt FULL_NAME "$FULL_NAME"

tell <<END

	SMARTHOST is an system to which you forward mail you 
	don't want to deliver yourself; it presumably has better 
	connectivity or routing informations than you do. 
	I suggest you to use your SMTP host REAL name.

END

prompt SMARTHOST "$SMARTHOST"
prompt SMTP_PORT "$SMTP_PORT"

if have_smail; then
echo -e "$BRIGHT"
> /etc/smail.conf

tell "%s detected, good." | printf -r "`smail -V`"

tell <<END
Emails should be delivered using the Smail MTA
---------------------------------------------------------------------
Please note! Smail attempts to deliver itself via SMTP only
this kind of addresses: x, x@[a.b.c.d] and x@y. An address
like x@y.z.t (i.e. with a full-qualified domain) will be routed
via the SMARTHOST. So, if you have a local domestic network and you
wish to use Smail as transport agent, do not use domains, but
only hostnames:  x@bach, y@mozart, z@puccini. Again: put the IP 
hosts bach, mozart and puccini in your /etc/hosts, if DNS is not
available on your network. Sorry!
---------------------------------------------------------------------
 
END
echo -e "$NORMAL"
else
tell <<END

	Emails will be delivered using the built-in sendmail.
	If SMARTHOST is set, sendmail (a small script) work fine;
	otherwise sendmail attempt to deliver by itself, 
	with very picturesques results!

END
fi
have_smail && smail_ask
save -n $resource config
}

smail_ask()
{
tell <<END

	Smail can be configured as daemon: in this case it listen 
	at the TCP port 25 for incoming messages and deliver emails 
	to local and remote users. Smail will repeatedly check its 
	input spool directory sleeping for the given INTERVAL. 
	The interval can be defined also  with complex syntax, 
	as "2h30m" (two hours and 30 minutes)

END

prompt RUN_AS_DAEMON "$RUN_AS_DAEMON"

prompt DEBUG_MODE "$DEBUG_MODE" "Run in foreground [debug mode]? (y/n)"
prompt INTERVAL "$INTERVAL"

}

smail_setup()
{
tell "Setting up Smail Transport Agent"
# SMAIL setup
# spool directory, etc.

mkdir -p /var/spool/mail
chown mail.root /var/spool/mail
chmod 775 /var/spool/mail
mkdir -p /var/spool/smail
chmod 2755 /var/spool/smail

mkdir -p /var/log/smail
chmod 776 /var/log/smail

# create /etc/smail.conf

if [ "$SMARTHOST" ] ; then
	smart_spec="smart_path=${SMARTHOST}\nsmart_transport=smtp"
else
	smart_spec="-smart_path"
fi

cat > /etc/smail.conf <<END
#/etc/smail.conf for mulinuz
# `tell DO NOT EDIT THIS FILE` - automatically re-generated 

# hostnames

#visible_name=
#hostnames=

# smart host

`echo -e $smart_spec`

END
}

status()
{
if [ "`pidof smail`" ] ; then
	echo up
else
	echo down
fi
}

stop()
{
stop-daemon smail
}

configure()
{
# old mqueue sendmail-compatible
mkdir -p  /var/spool/mqueue

have_smail || return 0
smail_setup 

if [ "$RUN_AS_DAEMON" = y ] ; then
	if [ "$DEBUG_MODE" = y ] ; then
		smail -d9 -odf -bd
	else
		smail -bd -q${INTERVAL:-10m}	
	fi
	pid=`pidof smail`
	echo "`tell The Smail daemon is listening at port 25`, pid $pid."
fi


}
