#-------------------------
# SCSI configuration 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="SCSI devices support"
VAR_LIST="CARD MODULE_PARAMETERS"
HIDDEN_LIST=""
MOD_LIST=""
CARD='aic7xxx'
MODULE_PARAMETERS=''
}

info()
{
tell <<END
			- SCSI support -

The scsi support in the muLinux kernel is modularized: the scsi_mod.o
contains the core of scsi support. The disk driver (sd_mod.o), 
cdrom driver (sr_mod.o), tape (st.o) and scsi generics driver (sg.o) 
represent the UPPER level drivers to support the various assorted 
devices which can be controlled. The LOWER level drivers are the ones 
that support the individual cards that are supported for the hardware 
platform that you are running under.

-- Note: I've tested myself only AIC7xxx driver.


END
}

requirement()
{
if [ -d /usr/srv/modules ]; then
	return 0
else
        echo "(SRV addon required)"
        return 1
fi
}

status()
{
r=`cat /proc/scsi/scsi 2>/dev/null`

case Z${r}Z in
ZZ|Z*none*Z)	echo down;;
*)  echo up;;
esac


}


stop()
{
tell "Unloading SCSI modules ..." 
(
rmmod sr_mod
rmmod sg
rmmod sd_mod
rmmod $CARD
rmmod scsi_mod
) 2>/dev/null
}

prepare()
{
resource=$1

echo
echo -n "`tell Rustic Scanning PCI SCSI controller` ... "
sleep 2; tell "done."
echo -e $BRIGHT
/bin/scan pci | rgrep SCSI 
echo -e $NORMAL

cat <<END

`tell Please, enter your SCSI driver name:`

	aic7xxx		Adaptec 274x,284x,294x,394x,3985
	ncr53c8xx	Symbios 53c8xx family
	ultrastor	Ultrastor 14F,24F,34F
	seagate		Seagate 8-bit cards, ST-01
	fdomain		Future Domain	16xx host adapters
	aha152x		Adaptec aha-1510,aha-1520,aha-1522,aha-2825
	aha1542		Adaptec aha-1542

END

prompt CARD "$CARD" 

tell "Enter addictional parameters for this module, or leave it blank"
prompt MODULE_PARAMETERS "$MODULE_PARAMETERS" 

save -n $resource configure
}

configure()
{
tell "Setting up SCSI drivers ...."
supported driver scsi_mod || load_module scsi/scsi_mod 
supported driver $CARD || load_module scsi/$CARD $MODULE_PARAMETERS
supported driver sd_mod || load_module scsi/sd_mod
supported driver sr_mod || load_module scsi/sr_mod
supported driver sg || load_module scsi/sg
}
