#-------------------------
# SAMBA configuration
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="SMB (wfw/NT fs share) client support"
VAR_LIST="SERVICE_NAME SERVER MOUNT_POINT USER_NAME PASSWORD UPPERCASE SERVER_NETBIOS_NAME CLIENT_NETBIOS_NAME ADVANCED_OPTIONS"
HIDDEN_LIST=""
MOD_LIST="fs/smbfs"

SERVICE_NAME='//www/public'
SERVER='server.sanvittore.it'
MOUNT_POINT='/samba'
USER_NAME='tina'
PASSWORD=''
UPPERCASE='y'
SERVER_NETBIOS_NAME=''
CLIENT_NETBIOS_NAME=''
ADVANCED_OPTIONS=''
}

info()
{

tell <<END
		     - WFW/NT Samba (SMB) support -

With this setup you can access drives exported by Windows for 
Workgroups, Lan Manager, Windows NT or compatible systems 
running TCP/IP. Expert can see "smbmount -h".

END

}

status()
{

if cat /proc/filesystems | rgrep smbfs >/dev/null
then
	echo up
else
	echo down
fi

}


prepare()
{
resource=$1

# service
tell << END

	SERVER is the hostname of the server machine.

	SERVICE_NAME  is the name of the service you want to use
	on the server. Thus  to connect to the directory "util" below 
	the service "c" on the Lan Manager server "wfw", you would use
	the servicename //wfw/c/util.


END
prompt SERVER "$SERVER"
prompt SERVICE_NAME "$SERVICE_NAME"

# mount point
tell << END

        MOUNT_POINT is the local directory  you  want  to  mount 
	the filesystem  over. You can access the service with
	"cd MOUNT_POINT" and list them with "df". 

END
prompt MOUNT_POINT "$MOUNT_POINT"

# auth

tell << END

	You may want to give the PASSWORD and/or an USER_NAME
	required by the server. Otherwise, leave blank. 

END
prompt USER_NAME "$USER_NAME"
prompt PASSWORD "$PASSWORD"
prompt UPPERCASE "$UPPERCASE" "Convert password to uppercase(y/n)?"

# netbios problems

tell << END

	If the server(client) has a different NETBIOS name 
	than its hostname, you should give its netbios name now. 
	Otherwise, leave blank or set to "".

END
prompt SERVER_NETBIOS_NAME "$SERVER_NETBIOS_NAME"
prompt CLIENT_NETBIOS_NAME "$CLIENT_NETBIOS_NAME"

# advanced

prompt ADVANCED_OPTIONS "$ADVANCED_OPTIONS"


save -n $resource configure
}



configure()
{

for m in $MOD_LIST
do
load_module $m
done

mkdir -p $MOUNT_POINT || ( echo "abort mkdir"; exit 1)

AUTH=
[ "$SERVER" ] && AUTH="$AUTH -I $SERVER"
[ "$USER_NAME" ] && AUTH="$AUTH -U $USER_NAME"
[ "$PASSWORD" ] && AUTH="$AUTH -P $PASSWORD"
[ -z "$AUTH" ] && AUTH="-n"

[ "$SERVER_NETBIOS_NAME" ] && AUTH="$AUTH -s $SERVER_NETBIOS_NAME"
[ "$CLIENT_NETBIOS_NAME" ] && AUTH="$AUTH -c $CLIENT_NETBIOS_NAME"
[ "$UPPERCASE" = n ] && AUTH="$AUTH -C"


tell "Mounting remote SMB systems ..."

smbmount $SERVICE_NAME $MOUNT_POINT $AUTH $ADVANCED_OPTIONS
echo "smbmount $SERVICE_NAME $MOUNT_POINT $AUTH $ADVANCED_OPTIONS"
df| rgrep $MOUNT_POINT
sleep 1
}
