#--------------------------
# Remote Dialin PPP Server
#--------------------------
#set -x

. /setup/lib/ppp

info()
{
cat <<END

		   - RDPS : Remote Dialin PPP Server -

This is the muLinux RDPS configuration utility, developed by
Henri Viret <hviret@compuserve.com> and adapted to libc5 by me.

It set this PC as a modem gateway to the LAN, offering to the remote
user all the possibilities he would have as if he were directly connected 
to the LAN: httpd, ftp, telnet, Samba shares, etc.

Required components:

    - mgetty	: waits for an incoming call and launches pppd
    - pppd		: attaches the remote station to the LAN
			  and gives it an IP address

Check also the consistency with following components :

    - port		: modem device
    - eth0		: network interface card, IP addresses
    - network 		: nameserver

END
}

requirement()
{
if [ "`which mgetty`" ]; then
        return 0
else
        echo "(VNC addon required)"
        return 1
fi
}

probe_modem()
{
chat -t 2 '' AT OK < /dev/modem > /dev/modem
}

# set status of rdps ...
status()
{
  if [ "`pidof mgetty`" ] ; then
      echo up
  else	
      echo down
  fi
}

# setup rdps down ...
stop()
{
  down
}
down()
{
  stop_rdps
  repl="$repl; s/^RS/#RS/g"
  echo "Setting down Remote Dialin PPP Server"
  wave -c 880 2 ; wave -c 440 4
  init_rdps
}
# setup rdps up ...
up()
{
  repl="$repl; s/^#RS/RS/g"
  echo "Setting up Remote Dialin PPP Server"; sleep 1
  wave -c 440 2 ; wave -c 880 4
  init_rdps
}

# initialize
init_rdps()
{
  cat /etc/inittab | sed "$repl" > /tmp/inittab
  cp /tmp/inittab  /etc/inittab
  rm /tmp/inittab
  # update  inittab
  init q
}

stop_rdps()
{
  kill -9 `pidof pppd` 2>/dev/null
  kill -9 `pidof mgetty` 2>/dev/null
}

# the status() function is in ppp.lib

prepare()
{
  resource=$1

  prompt LOGIN "$LOGIN" "Enter remote username"
  prompt PASSWORD "$PASSWORD" "Enter remote password"
  prompt IP "$IP" "Enter desired remote IP address"
  prompt RDPS "$RDPS" "Start Remote Dialin PPP Server now (up/down)?"

  save -n $resource configure
}

configure()
{

  supported device ttyS 
  if [ $? -ne 0 ] ; then
	setup -f port
  fi

  for m in ${MOD_LIST}
  do
    load_module ${m} 2>/dev/null 
  done
 

# Create /etc/ppp/dialin.opt 

cat > /etc/ppp/dialin.opt <<END
modem
crtscts
lock 
debug
proxyarp
-detach
asyncmap 0
-chap
+pap
connect ''
:${IP}
END


# PAP authentication 

cat /etc/ppp/pap-secrets | rgrep -v ${LOGIN} > /tmp/pap-secrets
( cat /tmp/pap-secrets;
cat <<END
${LOGIN}		*		${PASSWORD}	${IP}
END
) > /etc/ppp/pap-secrets

# configure mgetty logfiles

mkdir -p /var/log/mgetty
chmod 755 /var/log/mgetty

modem_ok=
probe_modem && modem_ok=1

# set server up/down and reinit ...
repl=""
if [ "$RDPS" = up ] && [ "$modem_ok" ] ; then
        repl="$repl; s/^#RS/RS/g"
        echo "Setting up Remote Dialin PPP Server"; sleep 1
	wave -c 440 2 ; wave -c 880 4
else
        repl="$repl; s/^RS/#RS/g"
	[ -z "$modem_ok" ] && echo "Modem didn't respond."
	echo "Setting down Remote Dialin PPP Server"
	wave -c 880 2 ; wave -c 440 4
	stop_rdps
fi

cat /etc/inittab | sed "$repl" > /tmp/inittab
cp /tmp/inittab  /etc/inittab
rm /tmp/inittab
# update  inittab
init q
}
