#-------------------------
# rdate (fetch the time from a remote server) 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="to setup your local time from a remote server"
VAR_LIST="TIME_SERVER"
HIDDEN_LIST=""
MOD_LIST=""
TIME_SERVER='192.168.1.2'
}

info()
{
tell <<END
	         	- RDATE support -

You have the chance to set your local date and time from
a remote host or IP address. This setup uses the RFC868 
protocol, which is usually implemented (on the time server)
as a built-in service of inetd.


END
}

requirement()
{
if [ "`which rdate`" ]; then
        return 0
else
        echo "(SRV addon required)"
        return 1
fi
}


prepare()
{
resource=$1
prompt TIME_SERVER "$TIME_SERVER" \
"Enter the IP address of your time-server"
save -n $resource configure
}


configure()
{
echo "`tell Getting time from:` `rdate -p ${TIME_SERVER} 2>&1`"
rdate -s ${TIME_SERVER} 2>/dev/null
}
