#-------------------------
# Config. PRINTER 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="printer support"
VAR_LIST="PRINTER PAGE RESOLUTION SCALE DISPLACEMENT"
HIDDEN_LIST=""
MOD_LIST=""
PRINTER='ascii'
PAGE='a4'
RESOLUTION='300x300'
SCALE='0.9x0.9'
DISPLACEMENT='0x0.4'
}

info()
{
cat <<END

  	 	       - Rustic Printer Setup -

muLinux support basically only ASCII parallel printers; remote UNIX
printers which understands "lpd" BSD protocol are supported, with
a ingeniuos script contributed by Tom Poindexter (tpoindex@nyx.net).

A limited support for POSTSCRIPT and HP-PCL printers is also
available. 

- Print with "lpr [file]". See lpr -h. No local spool,sorry. 
- Log in /var/log/lp.log.

END
}


prepare()
{
resource=$1

while [ 1 ] ;
do

cat<<END

This setup is for: 

		[1] a local parallel printer 
		[2] a remote UNIX printer

END

read -p "(1/2)? [1] " type 

[ -z "$type" ] && type=1

case "$type" in
2) # remote printer

cat <<END

	Thx to Tom Poindexter <tpoindex@nyx.net>, for that!

	Enter printer spec in the form:
		
			HOST:PRINTER_NAME

	PRINTER_NAME is the "printcap" name of the printer;
	HOST is the remote server hostname of ip address.
	You can override this setup with -Phost:printer switch.
	
END
[ -z "$PRINTER" ] && PRINTER="chet.sanvittore.it:lp"
prompt PRINTER "$PRINTER"
;;

1) # local printer

cat<<END

	muLinux support fews kind of printer's filter:

        "ps" is for true Postscript printers (i.e. Apple Laserwrite)
        "pcl" is for printers which understand HP-PCL (i.e. HP Laserjet)
        "ascii" for ASCII printing (work with almost printers).
	"raw" means no-filter; direct printer port access.

	If your printer fall in "ps" or "pcl" class, you can print
	ASCII, PGM, and TIFF (fax) files. "ps" printers support 
	also POSTSCRIPT files :) Otherwise, only ASCII o raw allowed.

END

[ -z "$PRINTER" ] && PRINTER=ascii
prompt PRINTER "$PRINTER"


case "$PRINTER" in
ascii|raw)
	;;
*)
cat <<END

	-- Tuning parameters (efix converter)

	RESOLUTION (XxY or X) set resolution of X by Y
	dots per inch; PAGE (a4,letter,legal) is the page format;
	SCALE (HorizxVert) scale the input by % factors and
	DISPLACEMENT (RightxDown) displace the output (<0 allowed).

END

prompt RESOLUTION "$RESOLUTION" 
prompt PAGE "$PAGE" 
prompt SCALE "$SCALE" 
prompt DISPLACEMENT "$DISPLACEMENT" 
;;
esac

esac

prompt correct "n" "Are you happy with this configuration (y/n)?"
[ "$correct" = y ] && break
done
	
save -n $resource configure
}



configure()
{
mkdir -p /var/spool/printer
mkdir -p /var/spool/printer/queue

[ -z "`lsmod| rgrep lp`" ] && setup -f port

}
