#-------------------------
#  BSD printcap config 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="Berkeley BSD printcap support"
VAR_LIST="DRIVER RESOLUTION SHEET PAPERSIZE ORIENTATION"
DRIVER='ascii'
PAPERSIZE='a4'
RESOLUTION='300x300'
ORIENTATION='portrait'
SHEET=1
}

info()
{
tell <<END

  	 	       - Berkeley Printing System -

This is the popular BSD spooler system for Linux, a suite
of commands like: lpr, lpd, lprm, lpc with these addictional
packages:

	1. "mpage", able to handle text->postscript transformations
	   papersize, orientation, multi-pages, etc.
	2. "lprMagic", an old package by the Author, able to 
	   handle automatic filtering selection (see /etc/lprMagic.conf)

With the lprMagic, you can use the lpr command in order to play
songs, using the spooler queue: so, "lpr *.mp3" and "lpr *.wav" works.  

END
}

requirement()
{
if [ "`which lpc`" ] ; then
	return 0
else
	echo "(VNC addon required)"
	return 1
fi
}

status()
{
pid=`pidof lpd`
if [ "$pid" ] ; then
        echo up
else
        echo down
fi
}

make_spooler()
{
# $1 printer name
# file permissions and directory

SPOOL="/var/spool/lp"
mkdir -p $SPOOL
SPOOLDIR=$SPOOL/$1
mkdir -p $SPOOLDIR
[ ! -f $SPOOL/log ] && : > $SPOOL/log
> $SPOOLDIR/lock
> $SPOOLDIR/acct
chown -R lp.lp $SPOOLDIR
chmod ug+w $SPOOLDIR
chmod +r $SPOOLDIR/lock
}

setup_samba()
{
cat >/etc/samba/printcap <<END
;
; /etc/samba/printcap
; printers: BSD part
; by M. Andreoli

[printers]
   comment = All Printers
   browseable = no
   path = /tmp
   printable = yes
   public = yes
   writable = no
   create mode = 0700
   print command = lpr -P%S %s
END
# restart Samba
kill -1 `pidof smbd` 2>/dev/null
}

stop()
{
> /etc/samba/printcap
stop-daemon lpd
}

query_gs()
{
[ "`which gs`" ] || return 1
#gs -v
gs -h > /tmp/gs_supported

ex /tmp/gs_supported <<END  2>&1 >/dev/null
/Available device/
1,. d
/Language interpreters:/
.,$ d
wq
END
return 0
}

default_printer()
{
if query_gs; then
	echo -e "$BRIGHT"
	gs -v
	echo -e "$NORMAL"
	tell "Ghostscript appairs installed in the system."
	tell "Supported drivers are:"
	echo -e "$GREEN"
	cat /tmp/gs_supported
	echo -e "$NORMAL"
fi
	echo 
	tell "Built-in drivers are: ascii, raw, hp-pcl"

prompt DRIVER "$DRIVER" "Please, select a driver for your printer"

case $DRIVER in
ascii|raw)
	DEVICE=$DRIVER
	;;
*)
	DEVICE="gs_$DRIVER"
	paper ask
	;;
esac	
}

paper()
{

case $DRIVER in
ascii|raw)
        DEVICE=$DRIVER
        ;;
*)
        DEVICE="gs_$DRIVER"
        ;;
esac

if [ "$1" = ask ] ; then
prompt PAPERSIZE "$PAPERSIZE" "Papersize (a3, a4, letter)"
prompt RESOLUTION "$RESOLUTION" "Resolution (i.e. 300x300, ...)"
prompt ORIENTATION "$ORIENTATION" "Orientation (landscape, portrait)"
prompt SHEET "$SHEET" "Page for sheet (1,2,4,8)"

elif [ "$1" = set ] ; then

default=/etc/lp.def
cat > $default <<END
device=$DEVICE
papersize=$PAPERSIZE
resolution=$RESOLUTION
orientation=$ORIENTATION
sheet=$SHEET
END
fi

}

prepare()
{
resource=$1
default_printer
save -n $resource configure
}

configure()
{
[ "`lsmod lp`" ] || setup -m misc/lp
setup_samba
paper set
PRINTERS='debug raw0 raw1 ascii fax lp'
for p in $PRINTERS
do
make_spooler $p
done
tell "Starting the BSD printing system: lpd." 
echo "`tell Default printer queue 'lp', using the driver` $DRIVER." 
pid=$(pidof lpd)
if [ "$pid" ] ; then
	kill -1 "$pid"
else 
	lpd > /dev/null
fi
}
