#-------------------------
# PPP link between two PCs 
#-------------------------

if [ "$resource" = ppp ] ; then
        echo "Called incorrectly: please use ppp0 or ppp1"
        exit 1
fi

ppp_n=$(echo $resource | sed s/ppp//g)

default()
{
default_ppp${ppp_n}
}

default_ppp()
{
# called incorrectly
}

default_ppp0()
{
ACTION=ask_the_user
RESOURCE="PPP link over the first serial port"
VAR_LIST="DEVICE SPEED IP DEFAULTROUTE MASQ"
HIDDEN_LIST=""
MOD_LIST="net/slhc net/ppp"
DEVICE='/dev/ttyS0'
SPEED='115200'
IP='192.168.1.1:192.168.1.2'
DEFAULTROUTE='n'
MASQ='n'
}

default_ppp1()
{
ACTION=ask_the_user
RESOURCE="PPP link over the second serial port"
VAR_LIST="DEVICE SPEED IP DEFAULTROUTE MASQ"
HIDDEN_LIST=""
MOD_LIST="net/slhc net/ppp"
DEVICE='/dev/ttyS1'
SPEED='115200'
IP='noipdefault'
DEFAULTROUTE='y'
MASQ='n'
}

info()
{

tell <<END | printf -r "${ppp_n}"

		- PPP serial line port: #%s -

Using this setup you can link together two computers using a 
"null-modem" serial cable, or using two modems in both sides plus 
a standard phone line.

My minimal null-modem cable, with only 3 Pins linked
together (Flow control allowed: XON/XOFF) looks like:

       Pin Name  Pin                               Pin
       Tx Data    2  -----------------------------  3
       Rx Data    3  -----------------------------  2
       Ground     7  -----------------------------  7

-- Note: the utility is smart enough to detect the modem (if any)
   and to initialize it. The modem will open the line immediately,
   without any ring (ATA command).
-- Probabily, the utility works also with external incoming phone calls
   (i.e. with regular RINGs) as dialin PPP server, but it is untested. 

END

}



mode()
{
        echo $IP | rgrep : > /dev/null
        if [ $? -eq 0 ] ; then
		echo server
        else
		echo client
        fi
}


. /setup/lib/ppp

stop()
{
pid=`pppd_pid $DEVICE`
interface=`pppd_interface $DEVICE`

if [  -z "$pid" ] ; then
	# no pid entry. pppd is negoziating?
	set -- `ps | rgrep pppd | rgrep $DEVICE`
	pid=$1
	interface=$resource
fi
if [ "$pid" ] ; then
kill -1 $pid && kill -9 $pid && echo "$interface (pid $pid) `tell stopped`"
ifconfig $interface down 2>/dev/null
fi

supported device ttyS || return
# reset modem, silenty
chat -t 1 '' ATZ OK '+++ATH0' OK < $DEVICE > $DEVICE
}


status()
{
device_status $DEVICE
}

prepare()
{

resource=$1


prompt DEVICE "$DEVICE" "Enter serial device"
prompt SPEED "$SPEED" "Enter serial speed (19200,38400,115200,...)"

tell <<END

	Would you like setup the PPP link  for
	  [1] a client machine  [2] a server machine

END


prompt model "1" "Enter (1/2)"

case $model in
1)
	IP=noipdefault
	DEFAULTROUTE="y"  
	MASQ=n
	;;
2)
	DEFAULTROUTE="n"  

tell <<END

	Please, enter static IP to be assigned to this server (local_ip)
	and to caller machine (remote_ip). Syntax:

		local:remote

END
	mode=`mode`
	if [ "$mode" = server ] ; then
		prompt IP "$IP"
	else
		prompt IP "local:remote"
	fi	

	tell "Activate IP-masquerading (NAT) for the remote peer"
	prompt MASQ "$MASQ"
	;;
esac

save -n $resource configure

}


modem_attach()
{
timeout=15; i=0
while [ 1 ] ; do
i=`expr $i + 1`
echo "Attempt $i, timeout $timeout secs. Control-C to interrupt."
chat -t $timeout '' ATZ OK ATX3 OK ATL1 OK $OPEN_LINE CONNECT '\d\c' < $DEVICE > $DEVICE
[ $? -eq 0 ] && echo "connect! Starting PPP negoziation ..." && return 0
done
echo "No peer's connection."
return 1
}

configure()
{

# load kernel drivers

cat /proc/devices| rgrep ttyS >/dev/null 
if [ $? -ne 0 ] ; then
	setup -f port
fi

for m in slhc ppp
do
[ -z "`cat /proc/modules| rgrep $m`" ] && load_module net/${m} 
done


case $DEFAULTROUTE in
y|Y|yes)
	DR="defaultroute"
	;;
n|N|no)
	DR="-defaultroute"
	;;
esac

# Check if the device is a modem. If no, a serial cable
# is assumed.

is_modem=
chat -t 1 '' ATZ OK '' < $DEVICE > $DEVICE && is_modem=yes

# create chat program able to put constrain the modem
# in attention state 

case `mode` in
server)
	OPEN_LINE="ATA"
	PASSIVE=passive
	;;
client)
	OPEN_LINE="ATDT"	# test, please!
	PASSIVE=
	;;
esac

# remove locks

tty=`basename $DEVICE`
lockfile="/var/lock/LCK..$tty"
rm -f $lockfile

# start link now
OPTIONS="debug local -crtscts xonxoff $PASSIVE persist -proxyarp -pap -chap connect ''"
if [ "$is_modem" ] ; then
	tell "Modem detected. Waiting for peer's connections ..."
	modem_attach && eval pppd $DEVICE $SPEED $DR $IP $OPTIONS
else
	eval pppd $DEVICE $SPEED $DR $IP $OPTIONS
fi
}

