#--------------------------
# portfw : port forwarding
#--------------------------

default()
{
ACTION=ask_the_user
RESOURCE="TCP/IP port-forwarding support"
VAR_LIST="PF1 PF2 PF3 PF4"
HIDDEN_LIST=""
MOD_LIST=""
}

info()
{
tell <<END
	              - TCP/IP port forwarding rules -

"Port-forwarding" is mechanism which redirect any TCP connections 
incoming to a local port (on this machine) to another port on a 
remote machine.

Example: you can redirect any HTTP connection to my port 80,
towards the port 81 on the intranet web server with the
ipaddr 192.168.1.100. It is assumed no real services are running
on the local port. 

Useful standard number for TCP/IP ports are: ftp(21), telnet(23),
smtp(25), pop3(110), dns(53), www(80) (see /etc/services)

END
}

status()
{
rules=`ipfwadm -F -l | rgrep -v "IP firewall"`

if [ -z "$rules" ] ; then
	echo down
else
	echo up
fi

}

store()
{
}


stop()
{
tell "Stopping port-forwarding ..."
kill -9 `pidof redir` > /dev/null
}

REDIR()
{
host=$1; lp=$2; rm=$3
if $(ps | rgrep "redir $host $lp $rm" > /dev/null) ; then
	:
else
	redir $host $lp $rm &
fi
}


pf_rule()
{
opt=$1
for r in $PF1 $PF2 $PF3 $PF4; do
	save=$IFS; IFS=","; set -- $r
	printf "  Port forwarding, rule: %4s -> %12s:%s" $1 $2 $3; echo
	REDIR $2 $1 $3
done
}


prepare()
{
resource=$1

tell <<END

muLinux Setup supports up to 4 (four) redirection rules, called
		     FW1, FW2, FW3 and FW4

The syntax for each rule is "local_port,remote_host,remote_port"
Example: the rule
			80,192.168.100,81

redirect port(80) to port 81, on the host 192.168.1.100
Please, stay blank, if you wish to disable a specific rule.

END


save $resource configure
}

configure()
{
pf_rule
}
