#-------------------------
# serial/parallel/mouse port 
#-------------------------

default()
{
ACTION=ask_the_user
RESOURCE="serial/parallel/mouse port support"
VAR_LIST="MODEM_DEVICE PRINTER_DEVICE MOUSE_DEVICE SERIAL_DEVICE EMULATE3BUTTONS USE_SETSERIAL PORT_LIST BASE_LIST IRQ_LIST"
HIDDEN_LIST="MOUSE_PROTOCOL"
MOD_LIST=""

MODEM_DEVICE='probe'
PRINTER_DEVICE='/dev/lp1'
MOUSE_DEVICE='probe'
SERIAL_DEVICE='/dev/ttyS0'
MOUSE_PROTOCOL='PS/2'
EMULATE3BUTTONS='no'
USE_SETSERIAL='y'
PORT_LIST='ttyS0 ttyS1'
BASE_LIST='- -'
IRQ_LIST='- -'
}


info()
{

tell <<END
		   - Serial/Parallel/Mouse device -

Configuration of serial ports (modem, serial mice), bus mouse
and printer port. 

Alert! Only serial mouse and PS2 mouse are supported with only
BASE floppy mounted. For other mice, mount X11 addon.

END
}

status()
{
case $ACTION in
configure)
	echo up
	;;
*)
	echo down
	;;
esac
}

sanitize()
{
MODEM_DEVICE=probe
MOUSE_DEVICE=probe
save -n $1 ask_the_user
}

unix_speak()
{
case $1 in
com1|COM1)
	echo /dev/ttyS0;;
com2|COM2)
	echo /dev/ttyS1;;
com3|COM3)
	echo /dev/ttyS2;;
com4|COM4)
	echo /dev/ttyS3;;
*)
	echo $1;;
esac
}


serial_setup()
{
tell "Setting up serial ports IRQ ..."
blist=$BASE_LIST
ilist=$IRQ_LIST

for port in $PORT_LIST
do
set -- $blist; base=$1; shift; blist="$@"
set -- $ilist; irq=$1;  shift; ilist="$@"

case $port in
*S[4-9]|*S[0-9][0-9])
        FLAGS="autoconfig session_lockout"
;;
*)
        FLAGS="skip_test autoconfig session_lockout"
;;
esac

case $irq in
-) irq_spec=auto_irq;;
*)         irq_spec="irq $irq";;
esac

case $base in
-) base_spec=;;
*)         base_spec="port $base";;
esac

setserial -b /dev/$port ${irq_spec} ${base_spec} $FLAGS
#echo -n  " $port/$irq"
done

}


prepare()
{
resource=$1

tell <<END

	Serial ports in Linux are called /dev/ttyS0 (COM1),
	/dev/ttyS1 (COM2), etc. Parallel ports are called
	/dev/lp0, /dev/lp1 (LPT1).
	
END

supported device ttyS || load_module misc/serial 
supported driver psaux || load_module misc/psaux
echo

while [ 1 ] ;
do
prompt MODEM_DEVICE $MODEM_DEVICE "Enter MODEM_DEVICE or /dev/null or probe" 

MODEM_DEVICE=$(unix_speak $MODEM_DEVICE)

case Z${MODEM_DEVICE}Z in
Z*probe*Z)
	echo -n "`tell Turn on the modem and press -ENTER-`"
	read enter
	MODEM_DEVICE=`/bin/scan modem`
	echo "Found [$MODEM_DEVICE]"
	;;
*)
	Done=yes
	;;	
esac

[ "$Done" ] && break
done


prompt PRINTER_DEVICE $PRINTER_DEVICE "Enter PRINTER_DEVICE or /dev/null"

tell <<END

	Having a spare serial port, you can use it for direct
	serial connection.

END
prompt SERIAL_DEVICE $SERIAL_DEVICE "Enter SERIAL_DEVICE or /dev/null" 

SERIAL_DEVICE=$(unix_speak $SERIAL_DEVICE)


tell <<END

	Mouse set up is more complex :)

	If your mouse is a SERIAL mouse, you have to select a
	serial device, as for modem: that's true for Microsoft
	Compatible mice, old Logitech, System Serial Mouse, etc. 

	If your mouse is a BUS mouse, you have to select
	some special devices:

        	PS/2 (aux port style):  /dev/psaux
        	Logitech BUS Mouse:     /dev/logibm
        	Microsoft BUS Mouse:    /dev/inportbm
        	ATI XL Bus Mouse:       /dev/atibm

END

while [ 1  ];
do
prompt MOUSE_DEVICE "$MOUSE_DEVICE" "Enter MOUSE_DEVICE or /dev/null or 'probe'" 
MOUSE_DEVICE=$(unix_speak $MOUSE_DEVICE)

case $MOUSE_DEVICE in
*probe*)
	> /tmp/probe
        /bin/scan mouse > /tmp/probe
	MOUSE_DEVICE=`cat /tmp/probe 2>/dev/null`
        if [ "$MOUSE_DEVICE" ] ; then
			echo "`tell Found` [$MOUSE_DEVICE]"
	else
		MOUSE_DEVICE=probe
	fi
	;;
*)	done=yes
	;;
esac

[ "$done" ] && break
done

tell <<END

        MOUSE_PROTOCOL is NOT related to vendor name.
        They are:

                Microsoft, Logitech, Mouseman, PS/2, etc.

        For ps2 mice, select PS/2; "Microsoft" work well for
        other mice.

        Emulate3Buttons=yes/no is for 2-button M$ Mouse

END


if [ "${MOUSE_DEVICE}" != /dev/null ] ; then 
	prompt MOUSE_PROTOCOL $MOUSE_PROTOCOL
	prompt EMULATE3BUTTONS $EMULATE3BUTTONS
fi

# setserial

tell <<END

	During the normal bootup process, only COM ports  1-4  are
	initialized,  using  the default I/O ports and IRQ values.
	In order to  change the COM ports to a non-standard 
	configuration, the  "setserial" program should be used. 

	Setup now ask you for a *list* of ports, base_address and IRQs.
	If You want a probe mecchanism, specify the special value "-"
	for ANY "base" and "irq". Example for two port:

		BASE_LIST:  - -
		IRQ_LIST:   - - 

	(see "setserial -h" for other info).

END

prompt USE_SETSERIAL $USE_SETSERIAL \
"Do You want to change serial port default setup?(y/n)" 

if [ "$USE_SETSERIAL" = y ] ; then

prompt PORT_LIST "$PORT_LIST" 
prompt BASE_LIST "$BASE_LIST" 
prompt IRQ_LIST "$IRQ_LIST" 

fi

save -n $resource configure
}



configure()
{

MODEM_DEVICE=$(unix_speak $MODEM_DEVICE)
MOUSE_DEVICE=$(unix_speak $MOUSE_DEVICE)
SERIAL_DEVICE=$(unix_speak $SERIAL_DEVICE)


# create links in /dev
cd /dev
rm -f modem lp mouse serial
ln -s ${MODEM_DEVICE} modem
ln -s ${MOUSE_DEVICE} mouse
ln -s ${PRINTER_DEVICE} lp 
ln -s ${SERIAL_DEVICE} serial 

# load basic modules

supported device ttyS || load_module misc/serial 
supported driver psaux || load_module misc/psaux


mod="misc/serial"

[ "${PRINTER_DEVICE}" != /dev/null ] && mod="$mod misc/lp"

# Mouse protocol

case "${MOUSE_DEVICE}" in
*psaux*|*bm*)
        MOUSE_PROTOCOL="PS/2"
        ;;
*)
        MOUSE_PROTOCOL="Microsoft"
esac

save -n port configure

# if X11 is'nt mounted, some error occour.

case "${MOUSE_DEVICE}" in
*psaux*)        mod="$mod misc/psaux";;
*inportbm*)     mod="$mod misc/msbusmouse";;
*atibm*)        mod="$mod misc/atixlmouse";;
*logibm*)       mod="$mod misc/busmouse";;
esac

for m in $mod
do
supported driver `basename $m` || load_module $m
done
# setserial

supported device ttyS && serial_setup


}
